/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.actions.TriConsumer;
import net.emaze.dysfunctional.dispatching.delegates.TriFunction;
import net.emaze.dysfunctional.dispatching.logic.TriPredicate;
import net.emaze.dysfunctional.tuples.Pair;
import net.emaze.dysfunctional.tuples.Triple;

public abstract class Tuples {
    public static <T, U, R> Function<Pair<T, U>, R> tupled(BiFunction<T, U, R> function) {
        dbc.precondition(function != null, "cannot apply a pair to a null function", new Object[0]);
        return pair -> function.apply(pair.first(), pair.second());
    }

    public static <T, U> Predicate<Pair<T, U>> tupled(BiPredicate<T, U> predicate) {
        dbc.precondition(predicate != null, "cannot apply a pair to a null predicate", new Object[0]);
        return pair -> predicate.test(pair.first(), pair.second());
    }

    public static <T, U> Consumer<Pair<T, U>> tupled(BiConsumer<T, U> consumer) {
        dbc.precondition(consumer != null, "cannot apply a pair to a null consumer", new Object[0]);
        return pair -> consumer.accept(pair.first(), pair.second());
    }

    public static <T, U, V, R> Function<Triple<T, U, V>, R> tupled(TriFunction<T, U, V, R> function) {
        dbc.precondition(function != null, "cannot apply a triple to a null function", new Object[0]);
        return triple -> function.apply(triple.first(), triple.second(), triple.third());
    }

    public static <T, U, V> Predicate<Triple<T, U, V>> tupled(TriPredicate<T, U, V> predicate) {
        dbc.precondition(predicate != null, "cannot apply a triple to a null predicate", new Object[0]);
        return triple -> predicate.test(triple.first(), triple.second(), triple.third());
    }

    public static <T, U, V> Consumer<Triple<T, U, V>> tupled(TriConsumer<T, U, V> consumer) {
        dbc.precondition(consumer != null, "cannot apply a triple to a null consumer", new Object[0]);
        return triple -> consumer.accept(triple.first(), triple.second(), triple.third());
    }

    public static abstract class Triples {
        public static <T, U, V, R> TriFunction<T, U, V, R> untupled(Function<Triple<T, U, V>, R> function) {
            dbc.precondition(function != null, "cannot untuple a null function", new Object[0]);
            return (first, second, third) -> function.apply(Triple.of(first, second, third));
        }

        public static <T, U, V> TriPredicate<T, U, V> untupled(Predicate<Triple<T, U, V>> predicate) {
            dbc.precondition(predicate != null, "cannot untuple a null predicate", new Object[0]);
            return (first, second, third) -> predicate.test(Triple.of(first, second, third));
        }

        public static <T, U, V> TriConsumer<T, U, V> untupled(Consumer<Triple<T, U, V>> consumer) {
            dbc.precondition(consumer != null, "cannot untuple a null consumer", new Object[0]);
            return (first, second, third) -> consumer.accept(Triple.of(first, second, third));
        }
    }

    public static abstract class Pairs {
        public static <T, U, R> BiFunction<T, U, R> untupled(Function<Pair<T, U>, R> function) {
            dbc.precondition(function != null, "cannot untuple a null function", new Object[0]);
            return (first, second) -> function.apply(Pair.of(first, second));
        }

        public static <T, U> BiPredicate<T, U> untupled(Predicate<Pair<T, U>> predicate) {
            dbc.precondition(predicate != null, "cannot untuple a null predicate", new Object[0]);
            return (first, second) -> predicate.test(Pair.of(first, second));
        }

        public static <T, U> BiConsumer<T, U> untupled(Consumer<Pair<T, U>> consumer) {
            dbc.precondition(consumer != null, "cannot untuple a null consumer", new Object[0]);
            return (first, second) -> consumer.accept(Pair.of(first, second));
        }
    }
}

