/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.emaze.dysfunctional.Sequences;
import net.emaze.dysfunctional.Tuples;
import net.emaze.dysfunctional.strategies.AllMatchesStrategy;
import net.emaze.dysfunctional.strategies.BinaryClause;
import net.emaze.dysfunctional.strategies.Clause;
import net.emaze.dysfunctional.strategies.FirstMatchStrategy;
import net.emaze.dysfunctional.strategies.MaybeFirstMatchStrategy;

public abstract class Strategies {
    @SafeVarargs
    public static <T, R> Function<T, R> firstMatch(Clause<T, R> ... clauses) {
        return new FirstMatchStrategy<T, R>(Arrays.asList(clauses));
    }

    @SafeVarargs
    public static <T, U, R> BiFunction<T, U, R> firstMatch(BinaryClause<T, U, R> ... clauses) {
        List unaryClauses = Sequences.of(clauses).map(BinaryClause::tupled).toList();
        return Tuples.Pairs.untupled(new FirstMatchStrategy(unaryClauses));
    }

    @SafeVarargs
    public static <T, R> Function<T, Optional<R>> maybeFirstMatch(Clause<T, R> ... clauses) {
        return new MaybeFirstMatchStrategy<T, R>(Arrays.asList(clauses));
    }

    @SafeVarargs
    public static <T, U, R> BiFunction<T, U, Optional<R>> maybeFirstMatch(BinaryClause<T, U, R> ... clauses) {
        List unaryClauses = Sequences.of(clauses).map(BinaryClause::tupled).toList();
        return Tuples.Pairs.untupled(new MaybeFirstMatchStrategy(unaryClauses));
    }

    @SafeVarargs
    public static <T, R> Function<T, List<R>> allMatches(Clause<T, R> ... clauses) {
        return new AllMatchesStrategy<T, R>(Arrays.asList(clauses));
    }

    @SafeVarargs
    public static <T, U, R> BiFunction<T, U, List<R>> allMatches(BinaryClause<T, U, R> ... clauses) {
        List unaryClauses = Sequences.of(clauses).map(BinaryClause::tupled).toList();
        return Tuples.Pairs.untupled(new AllMatchesStrategy(unaryClauses));
    }
}

