/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.emaze.dysfunctional.Consumers;
import net.emaze.dysfunctional.Iterations;
import net.emaze.dysfunctional.dispatching.actions.TriConsumer;
import net.emaze.dysfunctional.dispatching.composing.PipelinedBinaryConsumer;
import net.emaze.dysfunctional.dispatching.composing.PipelinedConsumer;
import net.emaze.dysfunctional.dispatching.composing.PipelinedTernaryConsumer;

public abstract class Pipelines {
    public static <T> Consumer<T> pipeline(Consumer<T> consumer) {
        return new PipelinedConsumer(Iterations.iterable(consumer));
    }

    public static <T> Consumer<T> pipeline(Consumer<T> former, Consumer<T> latter) {
        return new PipelinedConsumer(Iterations.iterable(former, latter));
    }

    public static <T> Consumer<T> pipeline(Consumer<T> first, Consumer<T> second, Consumer<T> third) {
        return new PipelinedConsumer(Iterations.iterable(first, second, third));
    }

    public static <T> Consumer<T> pipeline(Consumer<T> ... actions) {
        return new PipelinedConsumer(Iterations.iterable(actions));
    }

    public static <T1, T2> BiConsumer<T1, T2> pipeline(BiConsumer<T1, T2> consumer) {
        return new PipelinedBinaryConsumer(Iterations.iterable(consumer));
    }

    public static <T1, T2> BiConsumer<T1, T2> pipeline(BiConsumer<T1, T2> former, BiConsumer<T1, T2> latter) {
        return new PipelinedBinaryConsumer(Iterations.iterable(former, latter));
    }

    public static <T1, T2> BiConsumer<T1, T2> pipeline(BiConsumer<T1, T2> first, BiConsumer<T1, T2> second, BiConsumer<T1, T2> third) {
        return new PipelinedBinaryConsumer(Iterations.iterable(first, second, third));
    }

    public static <T1, T2> BiConsumer<T1, T2> pipeline(BiConsumer<T1, T2> ... actions) {
        return new PipelinedBinaryConsumer(Iterations.iterable(actions));
    }

    public static <T1, T2, T3> TriConsumer<T1, T2, T3> pipeline(TriConsumer<T1, T2, T3> consumer) {
        return new PipelinedTernaryConsumer(Iterations.iterable(consumer));
    }

    public static <T1, T2, T3> TriConsumer<T1, T2, T3> pipeline(TriConsumer<T1, T2, T3> former, TriConsumer<T1, T2, T3> latter) {
        return new PipelinedTernaryConsumer(Iterations.iterable(former, latter));
    }

    public static <T1, T2, T3> TriConsumer<T1, T2, T3> pipeline(TriConsumer<T1, T2, T3> first, TriConsumer<T1, T2, T3> second, TriConsumer<T1, T2, T3> third) {
        return new PipelinedTernaryConsumer(Iterations.iterable(first, second, third));
    }

    public static <T1, T2, T3> TriConsumer<T1, T2, T3> pipeline(TriConsumer<T1, T2, T3> ... actions) {
        return new PipelinedTernaryConsumer(Iterations.iterable(actions));
    }

    public static abstract class Ternary {
        public static <T1, T2, T3> TriConsumer<T1, T2, T3> pipeline(Iterable<TriConsumer<T1, T2, T3>> actions) {
            return new PipelinedTernaryConsumer(actions);
        }

        public static <T1, T2, T3> TriConsumer<T1, T2, T3> pipeline(Iterator<TriConsumer<T1, T2, T3>> actions) {
            return new PipelinedTernaryConsumer(Consumers.all(actions));
        }
    }

    public static abstract class Binary {
        public static <T1, T2> BiConsumer<T1, T2> pipeline(Iterable<BiConsumer<T1, T2>> actions) {
            return new PipelinedBinaryConsumer(actions);
        }

        public static <T1, T2> BiConsumer<T1, T2> pipeline(Iterator<BiConsumer<T1, T2>> actions) {
            return new PipelinedBinaryConsumer(Consumers.all(actions));
        }
    }

    public static abstract class Unary {
        public static <T> Consumer<T> pipeline(Iterable<Consumer<T>> actions) {
            return new PipelinedConsumer(actions);
        }

        public static <T> Consumer<T> pipeline(Iterator<Consumer<T>> actions) {
            return new PipelinedConsumer(Consumers.all(actions));
        }
    }
}

