/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.actions.TriConsumer;
import net.emaze.dysfunctional.dispatching.adapting.IteratingSupplier;
import net.emaze.dysfunctional.dispatching.delegates.TriFunction;
import net.emaze.dysfunctional.dispatching.logic.TriPredicate;

public abstract class Dispatching {
    public static <T> Runnable curry(Consumer<T> consumer, T value) {
        dbc.precondition(consumer != null, "cannot bind parameter of a null consumer", new Object[0]);
        return () -> consumer.accept(value);
    }

    public static <T1, T2> Consumer<T2> curry(BiConsumer<T1, T2> consumer, T1 first) {
        dbc.precondition(consumer != null, "cannot bind parameter of a null consumer", new Object[0]);
        return second -> consumer.accept(first, second);
    }

    public static <T1, T2, T3> BiConsumer<T2, T3> curry(TriConsumer<T1, T2, T3> consumer, T1 first) {
        dbc.precondition(consumer != null, "cannot bind parameter of a null consumer", new Object[0]);
        return (second, third) -> consumer.accept(first, second, third);
    }

    public static <T> BooleanSupplier curry(Predicate<T> predicate, T value) {
        dbc.precondition(predicate != null, "cannot bind parameter of a null predicate", new Object[0]);
        return () -> predicate.test(value);
    }

    public static <T1, T2> Predicate<T2> curry(BiPredicate<T1, T2> predicate, T1 first) {
        dbc.precondition(predicate != null, "cannot bind parameter of a null predicate", new Object[0]);
        return second -> predicate.test(first, second);
    }

    public static <T1, T2, T3> BiPredicate<T2, T3> curry(TriPredicate<T1, T2, T3> predicate, T1 first) {
        dbc.precondition(predicate != null, "cannot bind parameter of a null predicate", new Object[0]);
        return (second, third) -> predicate.test(first, second, third);
    }

    public static <T, R> Supplier<R> curry(Function<T, R> function, T value) {
        dbc.precondition(function != null, "cannot bind parameter of a null function", new Object[0]);
        return () -> function.apply(value);
    }

    public static <T1, T2, R> Function<T2, R> curry(BiFunction<T1, T2, R> function, T1 first) {
        dbc.precondition(function != null, "cannot bind parameter of a null function", new Object[0]);
        return second -> function.apply(first, second);
    }

    public static <T1, T2, T3, R> BiFunction<T2, T3, R> curry(TriFunction<T1, T2, T3, R> function, T1 first) {
        dbc.precondition(function != null, "cannot bind parameter of a null function", new Object[0]);
        return (second, third) -> function.apply(first, second, third);
    }

    public static <T1, T2, T3> BiConsumer<T1, T3> mcurry(TriConsumer<T1, T2, T3> consumer, T2 second) {
        dbc.precondition(consumer != null, "cannot bind parameter of a null consumer", new Object[0]);
        return (first, third) -> consumer.accept(first, second, third);
    }

    public static <T1, T2, T3, R> BiFunction<T1, T3, R> mcurry(TriFunction<T1, T2, T3, R> function, T2 second) {
        dbc.precondition(function != null, "cannot bind parameter of a null function", new Object[0]);
        return (first, third) -> function.apply(first, second, third);
    }

    public static <T1, T2, T3> BiPredicate<T1, T3> mcurry(TriPredicate<T1, T2, T3> predicate, T2 second) {
        dbc.precondition(predicate != null, "cannot bind parameter of a null predicate", new Object[0]);
        return (first, third) -> predicate.test(first, second, third);
    }

    public static <T1, T2> Consumer<T1> rcurry(BiConsumer<T1, T2> consumer, T2 second) {
        dbc.precondition(consumer != null, "cannot bind parameter of a null consumer", new Object[0]);
        return first -> consumer.accept(first, second);
    }

    public static <T1, T2, T3> BiConsumer<T1, T2> rcurry(TriConsumer<T1, T2, T3> consumer, T3 third) {
        dbc.precondition(consumer != null, "cannot bind parameter of a null consumer", new Object[0]);
        return (first, second) -> consumer.accept(first, second, third);
    }

    public static <T1, T2> Predicate<T1> rcurry(BiPredicate<T1, T2> predicate, T2 second) {
        dbc.precondition(predicate != null, "cannot bind parameter of a null predicate", new Object[0]);
        return first -> predicate.test(first, second);
    }

    public static <T1, T2, T3> BiPredicate<T1, T2> rcurry(TriPredicate<T1, T2, T3> predicate, T3 third) {
        dbc.precondition(predicate != null, "cannot bind parameter of a null predicate", new Object[0]);
        return (first, second) -> predicate.test(first, second, third);
    }

    public static <T1, T2, R> Function<T1, R> rcurry(BiFunction<T1, T2, R> function, T2 second) {
        dbc.precondition(function != null, "cannot bind parameter of a null function", new Object[0]);
        return first -> function.apply(first, second);
    }

    public static <T1, T2, T3, R> BiFunction<T1, T2, R> rcurry(TriFunction<T1, T2, T3, R> function, T3 third) {
        dbc.precondition(function != null, "cannot bind parameter of a null function", new Object[0]);
        return (first, second) -> function.apply(first, second, third);
    }

    public static <T> Predicate<T> ignore(BooleanSupplier proposition, Class<T> ignored) {
        dbc.precondition(proposition != null, "cannot ignore parameter of a null proposition", new Object[0]);
        return t -> proposition.getAsBoolean();
    }

    public static <T1, T2> BiPredicate<T1, T2> ignore1st(Predicate<T2> predicate, Class<T1> ignored) {
        dbc.precondition(predicate != null, "cannot ignore parameter of a null predicate", new Object[0]);
        return (first, second) -> predicate.test(second);
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> ignore1st(BiPredicate<T2, T3> predicate, Class<T1> ignored) {
        dbc.precondition(predicate != null, "cannot ignore parameter of a null predicate", new Object[0]);
        return (first, second, third) -> predicate.test(second, third);
    }

    public static <T1, T2> BiPredicate<T1, T2> ignore2nd(Predicate<T1> predicate, Class<T2> ignored) {
        dbc.precondition(predicate != null, "cannot ignore parameter of a null predicate", new Object[0]);
        return (first, second) -> predicate.test(first);
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> ignore2nd(BiPredicate<T1, T3> predicate, Class<T2> ignored) {
        dbc.precondition(predicate != null, "cannot ignore parameter of a null predicate", new Object[0]);
        return (first, second, third) -> predicate.test(first, third);
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> ignore3rd(BiPredicate<T1, T2> predicate, Class<T3> ignored) {
        dbc.precondition(predicate != null, "cannot ignore parameter of a null predicate", new Object[0]);
        return (first, second, third) -> predicate.test(first, second);
    }

    public static <T> Consumer<T> ignore(Runnable runnable, Class<T> ignored) {
        dbc.precondition(runnable != null, "cannot ignore parameter of a null runnable", new Object[0]);
        return first -> runnable.run();
    }

    public static <T1, T2> BiConsumer<T1, T2> ignore1st(Consumer<T2> consumer, Class<T1> ignored) {
        dbc.precondition(consumer != null, "cannot ignore parameter of a null consumer", new Object[0]);
        return (first, second) -> consumer.accept(second);
    }

    public static <T1, T2, T3> TriConsumer<T1, T2, T3> ignore1st(BiConsumer<T2, T3> consumer, Class<T1> ignored) {
        dbc.precondition(consumer != null, "cannot ignore parameter of a null consumer", new Object[0]);
        return (first, second, third) -> consumer.accept(second, third);
    }

    public static <T1, T2> BiConsumer<T1, T2> ignore2nd(Consumer<T1> consumer, Class<T2> ignored) {
        dbc.precondition(consumer != null, "cannot ignore parameter of a null consumer", new Object[0]);
        return (first, second) -> consumer.accept(first);
    }

    public static <T1, T2, T3> TriConsumer<T1, T2, T3> ignore2nd(BiConsumer<T1, T3> consumer, Class<T2> ignored) {
        dbc.precondition(consumer != null, "cannot ignore parameter of a null consumer", new Object[0]);
        return (first, second, third) -> consumer.accept(first, third);
    }

    public static <T1, T2, T3> TriConsumer<T1, T2, T3> ignore3rd(BiConsumer<T1, T2> consumer, Class<T3> ignored) {
        dbc.precondition(consumer != null, "cannot ignore parameter of a null consumer", new Object[0]);
        return (first, second, third) -> consumer.accept(first, second);
    }

    public static <T, R> Function<T, R> ignore(Supplier<R> supplier, Class<T> ignored) {
        dbc.precondition(supplier != null, "cannot ignore parameter of a null supplier", new Object[0]);
        return first -> supplier.get();
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> ignore1st(Function<T2, R> function, Class<T1> ignored) {
        dbc.precondition(function != null, "cannot ignore parameter of a null function", new Object[0]);
        return (first, second) -> function.apply(second);
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> ignore1st(BiFunction<T2, T3, R> function, Class<T1> ignored) {
        dbc.precondition(function != null, "cannot ignore parameter of a null function", new Object[0]);
        return (first, second, third) -> function.apply(second, third);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> ignore2nd(Function<T1, R> function, Class<T2> ignored) {
        dbc.precondition(function != null, "cannot ignore parameter of a null function", new Object[0]);
        return (first, second) -> function.apply(first);
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> ignore2nd(BiFunction<T1, T3, R> function, Class<T2> ignored) {
        dbc.precondition(function != null, "cannot ignore parameter of a null function", new Object[0]);
        return (first, second, third) -> function.apply(first, third);
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> ignore3rd(BiFunction<T1, T2, R> function, Class<T3> ignored) {
        dbc.precondition(function != null, "cannot ignore parameter of a null function", new Object[0]);
        return (first, second, third) -> function.apply(first, second);
    }

    public static <T> Supplier<Optional<T>> supplier(Iterator<T> adaptee) {
        return new IteratingSupplier<T>(adaptee);
    }

    public static Supplier<Void> supplier(Runnable adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null runnable", new Object[0]);
        return () -> {
            adaptee.run();
            return null;
        };
    }

    public static Supplier<Boolean> supplier(BooleanSupplier adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null boolean supplier", new Object[0]);
        return () -> adaptee.getAsBoolean();
    }

    public static <T> Function<T, Void> function(Consumer<T> adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null consumer", new Object[0]);
        return first -> {
            adaptee.accept(first);
            return null;
        };
    }

    public static <T1, T2> BiFunction<T1, T2, Void> function(BiConsumer<T1, T2> adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null consumer", new Object[0]);
        return (first, second) -> {
            adaptee.accept(first, second);
            return null;
        };
    }

    public static <T1, T2, T3> TriFunction<T1, T2, T3, Void> function(TriConsumer<T1, T2, T3> adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null consumer", new Object[0]);
        return (first, second, third) -> {
            adaptee.accept(first, second, third);
            return null;
        };
    }

    public static <T> Function<T, Boolean> function(Predicate<T> adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null predicate", new Object[0]);
        return adaptee::test;
    }

    public static <T1, T2> BiFunction<T1, T2, Boolean> function(BiPredicate<T1, T2> adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null predicate", new Object[0]);
        return adaptee::test;
    }

    public static <T1, T2, T3> TriFunction<T1, T2, T3, Boolean> function(TriPredicate<T1, T2, T3> adaptee) {
        dbc.precondition(adaptee != null, "cannot adapt a null predicate", new Object[0]);
        return adaptee::test;
    }

    public static <T> Runnable runnable(Supplier<T> supplier) {
        dbc.precondition(supplier != null, "cannot adapt a null supplier", new Object[0]);
        return supplier::get;
    }

    public static <T, R> Consumer<T> consumer(Function<T, R> function) {
        dbc.precondition(function != null, "cannot adapt a null function", new Object[0]);
        return function::apply;
    }

    public static <T1, T2, R> BiConsumer<T1, T2> consumer(BiFunction<T1, T2, R> function) {
        dbc.precondition(function != null, "cannot adapt a null function", new Object[0]);
        return function::apply;
    }

    public static <T1, T2, T3, R> TriConsumer<T1, T2, T3> consumer(TriFunction<T1, T2, T3, R> function) {
        dbc.precondition(function != null, "cannot adapt a null function", new Object[0]);
        return function::apply;
    }

    public static BooleanSupplier proposition(Supplier<Boolean> supplier) {
        dbc.precondition(supplier != null, "cannot adapt a null supplier", new Object[0]);
        return supplier::get;
    }

    public static <T> Predicate<T> predicate(Function<T, Boolean> function) {
        dbc.precondition(function != null, "cannot adapt a null function", new Object[0]);
        return function::apply;
    }

    public static <T1, T2> BiPredicate<T1, T2> predicate(BiFunction<T1, T2, Boolean> function) {
        dbc.precondition(function != null, "cannot adapt a null function", new Object[0]);
        return function::apply;
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> predicate(TriFunction<T1, T2, T3, Boolean> function) {
        dbc.precondition(function != null, "cannot adapt a null function", new Object[0]);
        return function::apply;
    }
}

