/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.windows;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class TrailsIterator<T, W extends Collection<?>>
extends ReadOnlyIterator<W> {
    private final Iterator<T> iter;
    private final Queue<Optional<T>> trails = new LinkedList<Optional<T>>();
    private final Function<Queue<Optional<T>>, W> copy;

    public TrailsIterator(Iterator<T> iter, int trailSize, Function<Queue<Optional<T>>, W> copy) {
        dbc.precondition(iter != null, "cannot create a TrailsIterator with a null iterator", new Object[0]);
        dbc.precondition(trailSize > 0, "cannot create a TrailsIterator with a non positive window size", new Object[0]);
        dbc.precondition(copy != null, "cannot create a TrailsIterator with a null copy semantics", new Object[0]);
        this.iter = iter;
        this.copy = copy;
        for (int i = 0; i != trailSize; ++i) {
            this.trails.add(Optional.empty());
        }
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public W next() {
        if (!this.iter.hasNext()) {
            throw new NoSuchElementException("iterator is consumed");
        }
        this.trails.add(Optional.of(this.iter.next()));
        this.trails.remove();
        return (W)((Collection)this.copy.apply(this.trails));
    }
}

