/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strategies;

import java.util.List;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.strategies.Clause;

public class FirstMatchStrategy<T, R>
implements Function<T, R> {
    private final List<Clause<T, R>> clauses;

    public FirstMatchStrategy(List<Clause<T, R>> clauses) {
        dbc.precondition(clauses != null, "clauses cannot be null", new Object[0]);
        this.clauses = clauses;
    }

    @Override
    public R apply(T t) {
        return (R)this.clauses.stream().filter(clause -> clause.condition.test(t)).map(clause -> clause.body.apply(t)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("No clauses found for %s", t)));
    }
}

