/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.Densify;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.ranges.SparseRange;

public class MakeRange<T>
implements Function<List<DenseRange<T>>, Range<T>> {
    private final SequencingPolicy<T> sequencer;
    private final Comparator<Optional<T>> comparator;
    private final DenseRange<T> empty;

    public MakeRange(SequencingPolicy<T> sequencer, Comparator<Optional<T>> comparator, T emptyValue) {
        this.sequencer = sequencer;
        this.comparator = comparator;
        this.empty = new DenseRange<T>(sequencer, comparator, Range.Endpoint.Include, emptyValue, Optional.of(emptyValue), Range.Endpoint.Exclude);
    }

    @Override
    public Range<T> apply(List<DenseRange<T>> wannaBeRange) {
        if (wannaBeRange.isEmpty()) {
            return this.empty;
        }
        if (wannaBeRange.size() == 1) {
            return wannaBeRange.get(0);
        }
        List<DenseRange<T>> densified = new Densify<T>(this.sequencer, this.comparator).apply(wannaBeRange);
        if (densified.size() == 1) {
            return densified.get(0);
        }
        return new SparseRange<T>(this.sequencer, this.comparator, densified);
    }
}

