/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.order;

import java.util.Comparator;
import java.util.function.BiFunction;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.order.Order;
import net.emaze.dysfunctional.tuples.Pair;

public class MakeOrder<T>
implements BiFunction<T, T, Pair<T, T>> {
    private final Comparator<T> comparator;

    public MakeOrder(Comparator<T> comparator) {
        dbc.precondition(comparator != null, "cannot create MakeOrder with a null comparator", new Object[0]);
        this.comparator = comparator;
    }

    @Override
    public Pair<T, T> apply(T lhs, T rhs) {
        Order result = Order.of(this.comparator.compare(lhs, rhs));
        T lower = Order.GT == result ? rhs : lhs;
        T higher = Order.GT == result ? lhs : rhs;
        return Pair.of(lower, higher);
    }
}

