/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.options.Either;

public class OptionalToEither<L, R>
implements Function<Optional<R>, Either<L, R>> {
    private final Supplier<L> left;

    public OptionalToEither(Supplier<L> left) {
        dbc.precondition(left != null, "cannot create OptionalToEither with a null left supplier", new Object[0]);
        this.left = left;
    }

    @Override
    public Either<L, R> apply(Optional<R> right) {
        dbc.precondition(right != null, "cannot transform a null optional to an either", new Object[0]);
        if (right.isPresent()) {
            return Either.right(right.get());
        }
        return Either.left(this.left.get());
    }
}

