/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import java.util.Optional;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;
import net.emaze.dysfunctional.options.Maybe;

public class Box<T> {
    private Maybe<T> content = Maybe.nothing();

    public static <E> Box<E> of(E element) {
        Box<E> box = new Box<E>();
        box.setContent(element);
        return box;
    }

    public static <E> Box<E> empty() {
        return new Box();
    }

    public <R> Box<R> map(Function<T, R> function) {
        dbc.precondition(function != null, "cannot perform fmap with a null function", new Object[0]);
        Maybe<R> m = this.content.map(function);
        return m.isPresent() ? Box.of(m.get()) : Box.empty();
    }

    public boolean isEmpty() {
        return !this.content.isPresent();
    }

    public boolean isPresent() {
        return this.content.isPresent();
    }

    public Optional<T> unload() {
        Maybe<T> old = this.content;
        this.content = Maybe.nothing();
        return old.optional();
    }

    public T getContent() {
        return this.content.get();
    }

    public void setContent(T content) {
        this.content = Maybe.just(content);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Box)) {
            return false;
        }
        Box other = (Box)rhs;
        return new EqualsBuilder().append(this.content, other.content).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.content).toHashCode();
    }

    public String toString() {
        return String.format("Box %s", this.content);
    }
}

