/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.emaze.dysfunctional.consumers.FirstElement;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.reductions.Every;

public class RoundrobinShortestIterator<E>
extends ReadOnlyIterator<E> {
    private final Iterator<? extends Iterator<E>> iterators;
    private final List<Iterator<E>> memory = new ArrayList<Iterator<E>>();
    private final Queue<E> prefetchedValues = new LinkedList();

    public <T extends Iterator<E>> RoundrobinShortestIterator(Iterator<T> iterators) {
        dbc.precondition(iterators != null, "trying to create a MultiplexingIterator from a null iterator of iterators", new Object[0]);
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        this.enforceMemoryIsFilled();
        if (this.prefetchedValues.isEmpty()) {
            this.prefetchValues();
        }
        return !this.prefetchedValues.isEmpty();
    }

    @Override
    public E next() {
        this.enforceMemoryIsFilled();
        if (this.prefetchedValues.isEmpty()) {
            this.prefetchValues();
        }
        return this.prefetchedValues.remove();
    }

    private void enforceMemoryIsFilled() {
        if (!this.memory.isEmpty()) {
            return;
        }
        while (this.iterators.hasNext()) {
            this.memory.add(this.iterators.next());
        }
    }

    private void prefetchValues() {
        if (!new Every<Iterator>(Iterator::hasNext).test(this.memory.iterator())) {
            return;
        }
        TransformingIterator values = new TransformingIterator(this.memory.iterator(), new FirstElement());
        while (values.hasNext()) {
            this.prefetchedValues.add(values.next());
        }
    }
}

