/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.iterations;

import java.util.Iterator;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class TransformingIterator<T, R>
implements Iterator<R> {
    private final Function<T, R> transformer;
    private final Iterator<T> iterator;

    public TransformingIterator(Iterator<T> iterator, Function<T, R> transformer) {
        dbc.precondition(iterator != null, "trying to create a TransformingIterator from a null iterator", new Object[0]);
        dbc.precondition(transformer != null, "trying to create a TransformingIterator with a null transformer", new Object[0]);
        this.iterator = iterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public R next() {
        return this.transformer.apply(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

