/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.interceptions;

import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.interceptions.Interceptor;

public class InterceptorAdapter<T, R>
implements Function<T, R> {
    private final Interceptor<T> interceptor;
    private final Function<T, R> inner;

    public InterceptorAdapter(Interceptor<T> interceptor, Function<T, R> inner) {
        dbc.precondition(interceptor != null, "cannot adapt a null interceptor", new Object[0]);
        dbc.precondition(inner != null, "cannot adapt with a null inner function", new Object[0]);
        this.interceptor = interceptor;
        this.inner = inner;
    }

    @Override
    public R apply(T value) {
        this.interceptor.before(value);
        try {
            R r = this.inner.apply(value);
            return r;
        }
        finally {
            this.interceptor.after(value);
        }
    }
}

