/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.groups;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.tuples.Pair;

public class PartitionBy<T, CA extends Collection<T>, CR extends Collection<T>>
implements Function<Iterator<T>, Pair<CA, CR>> {
    private final Predicate<T> partitioner;
    private final Supplier<CA> acceptedCollectionProvider;
    private final Supplier<CR> rejectedCollectionProvider;

    public PartitionBy(Predicate<T> partitioner, Supplier<CA> acceptedCollectionProvider, Supplier<CR> rejectedCollectionProvider) {
        dbc.precondition(partitioner != null, "cannot partition using a null partitioner", new Object[0]);
        dbc.precondition(acceptedCollectionProvider != null, "cannot partition using a null collection supplier for accepted values", new Object[0]);
        dbc.precondition(rejectedCollectionProvider != null, "cannot partition using a null collection supplier for rejected values", new Object[0]);
        this.partitioner = partitioner;
        this.acceptedCollectionProvider = acceptedCollectionProvider;
        this.rejectedCollectionProvider = rejectedCollectionProvider;
    }

    @Override
    public Pair<CA, CR> apply(Iterator<T> values) {
        dbc.precondition(values != null, "cannot partition a null iterator", new Object[0]);
        Collection accepted = (Collection)this.acceptedCollectionProvider.get();
        Collection refused = (Collection)this.rejectedCollectionProvider.get();
        while (values.hasNext()) {
            T value = values.next();
            Collection collection = this.partitioner.test(value) ? accepted : refused;
            collection.add(value);
        }
        return Pair.of(accepted, refused);
    }
}

