/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.filtering;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;

public class FilteringIterator<E>
implements Iterator<E> {
    private final Predicate<E> filter;
    private final Iterator<E> iterator;
    private boolean currentHasValue;
    private E current;

    public FilteringIterator(Iterator<E> iterator, Predicate<E> filter) {
        dbc.precondition(iterator != null, "trying to create a FilteringIterator from a null iterator", new Object[0]);
        dbc.precondition(filter != null, "trying to create a FilteringIterator from a null filter", new Object[0]);
        this.iterator = iterator;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        while (!this.currentHasValue && this.iterator.hasNext()) {
            E val = this.iterator.next();
            this.currentHasValue = this.filter.test(val);
            this.current = val;
        }
        return this.currentHasValue;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            E e = this.current;
            return e;
        }
        finally {
            this.currentHasValue = false;
        }
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

