/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;

public class MonitoringSupplier<R>
implements Supplier<R> {
    private final Supplier<R> nested;
    private final AtomicLong calls;

    public MonitoringSupplier(Supplier<R> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null supplier", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public R get() {
        this.calls.incrementAndGet();
        return this.nested.get();
    }
}

