/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;

public class MonitoringPredicate<T>
implements Predicate<T> {
    private final Predicate<T> nested;
    private final AtomicLong calls;

    public MonitoringPredicate(Predicate<T> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null predicate", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public boolean test(T value) {
        this.calls.incrementAndGet();
        return this.nested.test(value);
    }
}

