/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class MonitoringFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> nested;
    private final AtomicLong calls;

    public MonitoringFunction(Function<T, R> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null function", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public R apply(T value) {
        this.calls.incrementAndGet();
        return this.nested.apply(value);
    }
}

