/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.convolutions;

import java.util.Iterator;
import java.util.Optional;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.OptionalIterator;
import net.emaze.dysfunctional.tuples.Pair;

public class ZipLongestIterator<E1, E2>
extends ReadOnlyIterator<Pair<Optional<E1>, Optional<E2>>> {
    private final OptionalIterator<E1> former;
    private final OptionalIterator<E2> latter;

    public ZipLongestIterator(Iterator<E1> former, Iterator<E2> latter) {
        dbc.precondition(former != null, "trying to create a ZipLongestIterator from a null iterator (former)", new Object[0]);
        dbc.precondition(latter != null, "trying to create a ZipLongestIterator from a null iterator (latter)", new Object[0]);
        this.former = new OptionalIterator<E1>(former);
        this.latter = new OptionalIterator<E2>(latter);
    }

    @Override
    public boolean hasNext() {
        return this.former.hasNext() || this.latter.hasNext();
    }

    @Override
    public Pair<Optional<E1>, Optional<E2>> next() {
        return Pair.of(this.former.next(), this.latter.next());
    }
}

