/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.consumers;

import java.util.Iterator;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.output.OutputIterator;

public class ConsumeIntoOutputIterator<E>
implements Function<Iterator<E>, OutputIterator<E>> {
    private final OutputIterator<E> output;

    public ConsumeIntoOutputIterator(OutputIterator<E> output) {
        dbc.precondition(output != null, "OutputIterator cannot be null", new Object[0]);
        this.output = output;
    }

    @Override
    public OutputIterator<E> apply(Iterator<E> consumable) {
        dbc.precondition(consumable != null, "consuming a null iterator", new Object[0]);
        while (consumable.hasNext()) {
            dbc.state(this.output.hasNext(), "outputIterator is smaller than the inputIterator ", new Object[0]);
            this.output.next(consumable.next());
        }
        return this.output;
    }
}

