/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.consumers;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;

public class ConsumeIntoCollection<E, R extends Collection<E>>
implements Function<Iterator<E>, R> {
    private final Supplier<R> supplier;

    public ConsumeIntoCollection(Supplier<R> supplier) {
        dbc.precondition(supplier != null, "collection supplier cannot be null", new Object[0]);
        this.supplier = supplier;
    }

    @Override
    public R apply(Iterator<E> consumable) {
        dbc.precondition(consumable != null, "consuming a null iterator", new Object[0]);
        Collection out = (Collection)this.supplier.get();
        while (consumable.hasNext()) {
            out.add(consumable.next());
        }
        return (R)out;
    }
}

