/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.Optional;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.convolutions.ZipLongestIterator;
import net.emaze.dysfunctional.convolutions.ZipShortestIterator;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.order.ComparableComparator;
import net.emaze.dysfunctional.order.JustBeforeNothingComparator;
import net.emaze.dysfunctional.order.NextIntegerSequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.tuples.Pair;

public abstract class Zips {
    public static <T1, T2> Iterator<Pair<T1, T2>> shortest(Iterable<T1> former, Iterable<T2> latter) {
        dbc.precondition(former != null, "cannot call shortest with a null former iterable", new Object[0]);
        dbc.precondition(latter != null, "cannot call shortest with a null latter iterable", new Object[0]);
        return new ZipShortestIterator<T1, T2>(former.iterator(), latter.iterator());
    }

    public static <T1, T2> Iterator<Pair<T1, T2>> shortest(Iterator<T1> former, Iterator<T2> latter) {
        return new ZipShortestIterator<T1, T2>(former, latter);
    }

    public static <T1, T2> Iterator<Pair<T1, T2>> shortest(T1[] former, T2[] latter) {
        return new ZipShortestIterator<T1, T2>(new ArrayIterator<T1>(former), new ArrayIterator<T2>(latter));
    }

    public static <T1, T2> Iterator<Pair<Optional<T1>, Optional<T2>>> longest(Iterable<T1> former, Iterable<T2> latter) {
        dbc.precondition(former != null, "cannot call longest with a null former iterable", new Object[0]);
        dbc.precondition(latter != null, "cannot call longest with a null latter iterable", new Object[0]);
        return new ZipLongestIterator<T1, T2>(former.iterator(), latter.iterator());
    }

    public static <T1, T2> Iterator<Pair<Optional<T1>, Optional<T2>>> longest(Iterator<T1> former, Iterator<T2> latter) {
        return new ZipLongestIterator<T1, T2>(former, latter);
    }

    public static <T1, T2> Iterator<Pair<Optional<T1>, Optional<T2>>> longest(T1[] former, T2[] latter) {
        return new ZipLongestIterator<T1, T2>(new ArrayIterator<T1>(former), new ArrayIterator<T2>(latter));
    }

    public static <CT, ET> Iterator<Pair<CT, ET>> counted(Iterator<ET> iterator, Range<CT> range) {
        return new ZipShortestIterator(range.iterator(), iterator);
    }

    public static <T> Iterator<Pair<Integer, T>> counted(Iterator<T> iterator) {
        NextIntegerSequencingPolicy sequencer = new NextIntegerSequencingPolicy();
        JustBeforeNothingComparator comparator = new JustBeforeNothingComparator(new ComparableComparator());
        DenseRange<Integer> range = new DenseRange<Integer>(sequencer, comparator, Range.Endpoint.Include, 0, Optional.of(Integer.MAX_VALUE), Range.Endpoint.Include);
        return new ZipShortestIterator(range.iterator(), iterator);
    }

    public static <T> Iterator<Pair<Integer, T>> counted(Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot call counted with a null iterable", new Object[0]);
        NextIntegerSequencingPolicy sequencer = new NextIntegerSequencingPolicy();
        JustBeforeNothingComparator comparator = new JustBeforeNothingComparator(new ComparableComparator());
        DenseRange<Integer> range = new DenseRange<Integer>(sequencer, comparator, Range.Endpoint.Include, 0, Optional.of(Integer.MAX_VALUE), Range.Endpoint.Include);
        return new ZipShortestIterator(range.iterator(), iterable.iterator());
    }

    public static <CT, ET> Iterator<Pair<CT, ET>> counted(Iterable<ET> iterable, Range<CT> range) {
        dbc.precondition(iterable != null, "cannot call counted with a null iterable", new Object[0]);
        return new ZipShortestIterator(range.iterator(), iterable.iterator());
    }

    public static <T> Iterator<Pair<Integer, T>> counted(T ... array) {
        dbc.precondition(array != null, "cannot call counted with a null array", new Object[0]);
        NextIntegerSequencingPolicy sequencer = new NextIntegerSequencingPolicy();
        JustBeforeNothingComparator comparator = new JustBeforeNothingComparator(new ComparableComparator());
        DenseRange<Integer> range = new DenseRange<Integer>(sequencer, comparator, Range.Endpoint.Include, 0, Optional.of(Integer.MAX_VALUE), Range.Endpoint.Include);
        return new ZipShortestIterator(range.iterator(), new ArrayIterator<T>(array));
    }

    public static <CT, ET> Iterator<Pair<CT, ET>> counted(ET[] array, Range<CT> range) {
        dbc.precondition(array != null, "cannot call counted with a null array", new Object[0]);
        return new ZipShortestIterator(range.iterator(), new ArrayIterator<ET>(array));
    }
}

