/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import net.emaze.dysfunctional.Filtering;
import net.emaze.dysfunctional.Iterations;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.filtering.FilteringIterator;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.SingletonIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.options.Box;
import net.emaze.dysfunctional.options.Either;
import net.emaze.dysfunctional.options.Maybe;

public abstract class Options {

    public static abstract class Eithers {
        public static <LT, RT> Either<LT, RT> pure(RT value) {
            return Either.right(value);
        }

        public static <LT, RT> Either<LT, RT> pure(Class<LT> leftClass, RT value) {
            return Either.right(value);
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(Iterator<RT> values) {
            return new TransformingIterator<Object, Either>(values, Either::right);
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(Iterable<RT> values) {
            dbc.precondition(values != null, "cannot perform pures on a null iterable", new Object[0]);
            return new TransformingIterator<Object, Either>(values.iterator(), Either::right);
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT value) {
            return new TransformingIterator<Object, Either>(new SingletonIterator<RT>(value), Either::right);
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT first, RT second) {
            return new TransformingIterator<Object, Either>(Iterations.iterator(first, second), Either::right);
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT first, RT second, RT third) {
            return new TransformingIterator<Object, Either>(Iterations.iterator(first, second, third), Either::right);
        }

        public static <LT, RT> Iterator<Either<LT, RT>> pures(RT ... values) {
            return new TransformingIterator<Object, Either>(ArrayIterator.of(values), Either::right);
        }

        public static <LT, RT, LR, RR> Function<Either<LT, RT>, Either<LR, RR>> lift(Function<LT, LR> left, Function<RT, RR> right) {
            dbc.precondition(left != null, "cannot lift to either with a null left function", new Object[0]);
            dbc.precondition(right != null, "cannot lift to either with a null right function", new Object[0]);
            return e -> e.map(left, right);
        }

        public static <LT, RT> Iterator<LT> lefts(Iterator<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch lefts from a null iterator", new Object[0]);
            TransformingIterator<Either, Optional> maybes = new TransformingIterator<Either, Optional>(eithers, e -> e.left());
            FilteringIterator<Optional> justs = new FilteringIterator<Optional>(maybes, Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }

        public static <LT, RT> Iterator<LT> lefts(Iterable<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch lefts from a null iterable", new Object[0]);
            TransformingIterator<Either, Optional> maybes = new TransformingIterator<Either, Optional>(eithers.iterator(), e -> e.left());
            FilteringIterator<Optional> justs = new FilteringIterator<Optional>(maybes, Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }

        public static <LT, RT> Iterator<RT> rights(Iterator<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch rights from a null iterator", new Object[0]);
            TransformingIterator<Either, Optional> maybes = new TransformingIterator<Either, Optional>(eithers, e -> e.right());
            FilteringIterator<Optional> justs = new FilteringIterator<Optional>(maybes, Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }

        public static <LT, RT> Iterator<RT> rights(Iterable<Either<LT, RT>> eithers) {
            dbc.precondition(eithers != null, "can not fetch rights from a null iterator", new Object[0]);
            TransformingIterator<Either, Optional> maybes = new TransformingIterator<Either, Optional>(eithers.iterator(), e -> e.right());
            FilteringIterator<Optional> justs = new FilteringIterator<Optional>(maybes, Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }
    }

    public static abstract class Boxes {
        public static <T> Box<T> pure(T value) {
            return Box.of(value);
        }

        public static <T> Iterator<Box<T>> pures(Iterator<T> values) {
            return new TransformingIterator<Object, Box>(values, Box::of);
        }

        public static <T> Iterator<Box<T>> pures(Iterable<T> values) {
            dbc.precondition(values != null, "cannot perform pures on a null iterable", new Object[0]);
            return new TransformingIterator<Object, Box>(values.iterator(), Box::of);
        }

        public static <T> Iterator<Box<T>> pures(T value) {
            return new TransformingIterator<Object, Box>(new SingletonIterator<T>(value), Box::of);
        }

        public static <T> Iterator<Box<T>> pures(T first, T second) {
            return new TransformingIterator<Object, Box>(Iterations.iterator(first, second), Box::of);
        }

        public static <T> Iterator<Box<T>> pures(T first, T second, T third) {
            return new TransformingIterator<Object, Box>(Iterations.iterator(first, second, third), Box::of);
        }

        public static <T> Iterator<Box<T>> pures(T ... values) {
            return new TransformingIterator<Object, Box>(Iterations.iterator(values), Box::of);
        }

        public static <T> Box<T> join(Box<Box<T>> box) {
            if (box.isPresent()) {
                return box.getContent();
            }
            return Box.empty();
        }

        public static <T, R> Function<Box<T>, Box<R>> lift(Function<T, R> function) {
            dbc.precondition(function != null, "cannot lift to box with a null function", new Object[0]);
            return box -> box.map(function);
        }
    }

    public static abstract class Maybes {
        public static <T> Maybe<T> toMaybe(Optional<T> optional) {
            dbc.precondition(optional != null, "cannot convert a null optional to a maybe", new Object[0]);
            return new Maybe<Object>(optional.orElse(null), optional.isPresent());
        }

        public static <T> Optional<T> pure(T value) {
            return Optional.of(value);
        }

        public static <T> Iterator<Optional<T>> pures(Iterator<T> values) {
            return new TransformingIterator<Object, Optional>(values, Optional::of);
        }

        public static <T> Iterator<Optional<T>> pures(Iterable<T> values) {
            dbc.precondition(values != null, "cannot perform pures on a null iterable", new Object[0]);
            return new TransformingIterator<Object, Optional>(values.iterator(), Optional::of);
        }

        public static <T> Iterator<Optional<T>> pures(T value) {
            return new TransformingIterator<Object, Optional>(new SingletonIterator<T>(value), Optional::of);
        }

        public static <T> Iterator<Optional<T>> pures(T first, T second) {
            return new TransformingIterator<Object, Optional>(Iterations.iterator(first, second), Optional::of);
        }

        public static <T> Iterator<Optional<T>> pures(T first, T second, T third) {
            return new TransformingIterator<Object, Optional>(Iterations.iterator(first, second, third), Optional::of);
        }

        public static <T> Iterator<Optional<T>> pures(T ... values) {
            return new TransformingIterator<Object, Optional>(Iterations.iterator(values), Optional::of);
        }

        public static <T> Iterator<T> justs(Iterator<Optional<T>> maybes) {
            FilteringIterator<Optional> justs = new FilteringIterator<Optional>(maybes, Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }

        public static <T> Iterator<T> justs(Iterable<Optional<T>> maybes) {
            dbc.precondition(maybes != null, "cannot perform justs on a null iterable of Maybes", new Object[0]);
            FilteringIterator<Optional> justs = new FilteringIterator<Optional>(maybes.iterator(), Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }

        public static <T> Iterator<T> justs(Optional<T> first, Optional<T> second) {
            Iterator<Optional<T>> iterator = Iterations.iterator(first, second);
            Iterator<Optional> justs = Filtering.filter(iterator, Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }

        public static <T> Iterator<T> justs(Optional<T> first, Optional<T> second, Optional<T> third) {
            Iterator<Optional<T>> iterator = Iterations.iterator(first, second, third);
            Iterator<Optional> justs = Filtering.filter(iterator, Optional::isPresent);
            return new TransformingIterator<Optional, Object>(justs, Optional::get);
        }

        public static <T> Optional<T> lift(T value) {
            return Optional.ofNullable(value);
        }

        public static <T, R> Function<Optional<T>, Optional<R>> lift(Function<T, R> function) {
            dbc.precondition(function != null, "cannot lift to optional with a null function", new Object[0]);
            return o -> o.map(function);
        }

        public static <T> Iterator<Optional<T>> lifts(Iterator<T> iterator) {
            return new TransformingIterator<Object, Optional>(iterator, Optional::ofNullable);
        }

        public static <T> Iterator<Optional<T>> lifts(Iterable<T> iterable) {
            dbc.precondition(iterable != null, "cannot perform lifts on a null iterable", new Object[0]);
            return new TransformingIterator<Object, Optional>(iterable.iterator(), Optional::ofNullable);
        }

        public static <T> Iterator<Optional<T>> lifts(T first, T second) {
            Iterator<T> iterator = Iterations.iterator(first, second);
            return new TransformingIterator<Object, Optional>(iterator, Optional::ofNullable);
        }

        public static <T> Iterator<Optional<T>> lifts(T first, T second, T third) {
            Iterator<T> iterator = Iterations.iterator(first, second, third);
            return new TransformingIterator<Object, Optional>(iterator, Optional::ofNullable);
        }

        public static <T> T drop(Optional<T> optional) {
            dbc.precondition(optional != null, "cannot drop a null optional", new Object[0]);
            return optional.orElse(null);
        }

        public static <T> Iterator<T> drops(Iterator<Optional<T>> iterator) {
            return new TransformingIterator<Optional, Object>(iterator, Maybes::drop);
        }

        public static <T> Iterator<T> drops(Iterable<Optional<T>> iterable) {
            dbc.precondition(iterable != null, "cannot perform drops on a null iterable", new Object[0]);
            return new TransformingIterator<Optional, Object>(iterable.iterator(), Maybes::drop);
        }

        public static <T> Iterator<T> drops(Optional<T> first, Optional<T> second) {
            return new TransformingIterator<Optional, Object>(Iterations.iterator(first, second), Maybes::drop);
        }

        public static <T> Iterator<T> drops(Optional<T> first, Optional<T> second, Optional<T> third) {
            return new TransformingIterator<Optional, Object>(Iterations.iterator(first, second, third), Maybes::drop);
        }

        public static <T> Optional<T> join(Optional<Optional<T>> maybe) {
            if (maybe.isPresent()) {
                return maybe.get();
            }
            return Optional.empty();
        }
    }
}

