/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.emaze.dysfunctional.Compositions;
import net.emaze.dysfunctional.casts.Vary;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.ConstantSupplier;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.iterations.TransformingIterator;
import net.emaze.dysfunctional.multiplexing.ChainIterator;
import net.emaze.dysfunctional.multiplexing.CyclicIterator;
import net.emaze.dysfunctional.multiplexing.RoundrobinIterator;
import net.emaze.dysfunctional.multiplexing.RoundrobinLongestIterator;
import net.emaze.dysfunctional.multiplexing.RoundrobinShortestIterator;
import net.emaze.dysfunctional.multiplexing.UnchainIterator;
import net.emaze.dysfunctional.multiplexing.UnchainLongestIterator;
import net.emaze.dysfunctional.multiplexing.UnchainShortestIterator;

public abstract class Multiplexing {
    public static <I extends Iterable<E>, E> Iterator<E> flatten(Iterator<I> iterables) {
        return new ChainIterator(new TransformingIterator<Iterable, Iterator>(iterables, Iterable::iterator));
    }

    public static <I extends Iterable<E>, E> Iterator<E> flatten(Iterable<I> iterables) {
        dbc.precondition(iterables != null, "cannot flatten a null iterable", new Object[0]);
        Iterator<I> iterator = iterables.iterator();
        return new ChainIterator(new TransformingIterator<Iterable, Iterator>(iterator, Iterable::iterator));
    }

    public static <E, I extends Iterable<E>> Iterator<E> flatten(I ... iterables) {
        ArrayIterator<I> iterator = ArrayIterator.of(iterables);
        return new ChainIterator(new TransformingIterator<Iterable, Iterator>(iterator, Iterable::iterator));
    }

    public static <E, I extends Iterator<E>> Iterator<E> chain(Iterator<I> iterators) {
        return new ChainIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<E> chain(Iterable<I> iterators) {
        dbc.precondition(iterators != null, "cannot chain a null iterable", new Object[0]);
        return new ChainIterator(iterators.iterator());
    }

    public static <E, I extends Iterator<E>> Iterator<E> chain(I ... iterators) {
        return new ChainIterator(ArrayIterator.of(iterators));
    }

    public static <C extends Collection<E>, E> Iterator<C> unchain(int channelSize, Iterator<E> iterator, Supplier<C> channelProvider) {
        return new UnchainIterator<C, E>(channelSize, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> unchain(int channelSize, Iterator<E> iterator) {
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainIterator(channelSize, iterator, channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> unchain(int channelSize, Iterable<E> iterable, Supplier<C> channelProvider) {
        dbc.precondition(iterable != null, "cannot unchain a null iterable", new Object[0]);
        return new UnchainIterator<C, E>(channelSize, iterable.iterator(), channelProvider);
    }

    public static <E> Iterator<List<E>> unchain(int channelSize, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot unchain a null iterable", new Object[0]);
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainIterator(channelSize, iterable.iterator(), channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> unchain(int channelSize, Supplier<C> channelProvider, E ... array) {
        return new UnchainIterator<C, E>(channelSize, new ArrayIterator<E>(array), channelProvider);
    }

    public static <E> Iterator<List<E>> unchain(int channelSize, E ... array) {
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainIterator(channelSize, new ArrayIterator<E>(array), channelFactory);
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobin(Iterator<I> iterators) {
        return new RoundrobinIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobin(Iterable<I> iterators) {
        dbc.precondition(iterators != null, "cannot roundrobin a null iterable", new Object[0]);
        return new RoundrobinIterator(iterators.iterator());
    }

    public static <E> Iterator<E> roundrobin(Iterator<E> ... iterators) {
        return new RoundrobinIterator(ArrayIterator.of(iterators));
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobinShortest(Iterator<I> iterators) {
        return new RoundrobinShortestIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<E> roundrobinShortest(Iterable<I> iterators) {
        dbc.precondition(iterators != null, "cannot roundrobinShortest a null iterable", new Object[0]);
        Iterator<I> iterator = iterators.iterator();
        return new RoundrobinShortestIterator(iterator);
    }

    public static <E> Iterator<E> roundrobinShortest(Iterator<E> ... iterators) {
        ArrayIterator<Iterator<E>> iterator = ArrayIterator.of(iterators);
        return new RoundrobinShortestIterator(iterator);
    }

    public static <E, I extends Iterator<E>> Iterator<Optional<E>> roundrobinLongest(Iterator<I> iterators) {
        return new RoundrobinLongestIterator(iterators);
    }

    public static <E, I extends Iterator<E>> Iterator<Optional<E>> roundrobinLongest(Iterable<I> iterators) {
        dbc.precondition(iterators != null, "cannot roundrobinLongest a null iterable", new Object[0]);
        Iterator<I> iterator = iterators.iterator();
        return new RoundrobinLongestIterator(iterator);
    }

    public static <E> Iterator<Optional<E>> roundrobinLongest(Iterator<E> ... iterators) {
        ArrayIterator<Iterator<E>> iterator = ArrayIterator.of(iterators);
        return new RoundrobinLongestIterator(iterator);
    }

    public static <E> Iterator<E> cycle(Iterator<E> iterator) {
        return new CyclicIterator<E>(iterator);
    }

    public static <E> Iterator<E> cycle(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot cycle a null iterable", new Object[0]);
        return new CyclicIterator<E>(iterable.iterator());
    }

    public static <E> Iterator<E> cycle(E ... array) {
        return new CyclicIterator<E>(ArrayIterator.of(array));
    }

    public static <C extends Collection<E>, E> Iterator<C> unchainShortest(int channelSize, Iterator<E> iterator, Supplier<C> channelProvider) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        return new UnchainShortestIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> unchainShortest(int channelSize, Iterator<E> iterator) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainShortestIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> unchainShortest(int channelSize, Iterable<E> iterable, Supplier<C> channelProvider) {
        dbc.precondition(iterable != null, "cannot unchainShortest a null iterable", new Object[0]);
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        Iterator<E> iterator = iterable.iterator();
        return new UnchainShortestIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> unchainShortest(int channelSize, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot unchainShortest a null iterable", new Object[0]);
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        Iterator<E> iterator = iterable.iterator();
        return new UnchainShortestIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<E>, E> Iterator<C> unchainShortest(int channelSize, Supplier<C> channelProvider, E ... array) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        ArrayIterator<E> iterator = new ArrayIterator<E>(array);
        return new UnchainShortestIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<E>> unchainShortest(int channelSize, E ... array) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        ArrayIterator<E> iterator = new ArrayIterator<E>(array);
        return new UnchainShortestIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<Optional<E>>, E> Iterator<C> unchainLongest(int channelSize, Iterator<E> iterator, Supplier<C> channelProvider) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        return new UnchainLongestIterator<C, E>(channelsSizesProvider, iterator, channelProvider);
    }

    public static <E> Iterator<List<Optional<E>>> unchainLongest(int channelSize, Iterator<E> iterator) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainLongestIterator(channelsSizesProvider, iterator, channelFactory);
    }

    public static <C extends Collection<Optional<E>>, E> Iterator<C> unchainLongest(int channelSize, Iterable<E> iterable, Supplier<C> channelProvider) {
        dbc.precondition(iterable != null, "cannot unchainLongest a null iterable", new Object[0]);
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        return new UnchainLongestIterator<C, E>(channelsSizesProvider, iterable.iterator(), channelProvider);
    }

    public static <E> Iterator<List<Optional<E>>> unchainLongest(int channelSize, Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot unchainLongest a null iterable", new Object[0]);
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainLongestIterator(channelsSizesProvider, iterable.iterator(), channelFactory);
    }

    public static <C extends Collection<Optional<E>>, E> Iterator<C> unchainLongest(int channelSize, Supplier<C> channelProvider, E ... array) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        return new UnchainLongestIterator<C, E>(channelsSizesProvider, new ArrayIterator<E>(array), channelProvider);
    }

    public static <E> Iterator<List<Optional<E>>> unchainLongest(int channelSize, E ... array) {
        ConstantSupplier<Optional<Integer>> channelsSizesProvider = new ConstantSupplier<Optional<Integer>>(Optional.of(channelSize));
        Supplier channelFactory = Compositions.compose(new Vary(), new ArrayListFactory());
        return new UnchainLongestIterator(channelsSizesProvider, new ArrayIterator<E>(array), channelFactory);
    }
}

