/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.TriFunction;
import net.emaze.dysfunctional.dispatching.delegates.UnaryOperatorsComposer;
import net.emaze.dysfunctional.dispatching.logic.TriPredicate;

public abstract class Compositions {
    public static <T, R> Supplier<R> compose(Function<T, R> f, Supplier<T> g) {
        dbc.precondition(f != null, "cannot compose supplier with a null function", new Object[0]);
        dbc.precondition(g != null, "cannot compose function with a null supplier", new Object[0]);
        return () -> f.apply(g.get());
    }

    public static <T2, T1, R> Function<T1, R> compose(Function<T2, R> f, Function<T1, T2> g) {
        dbc.precondition(f != null, "cannot compose a null function", new Object[0]);
        dbc.precondition(g != null, "cannot compose a null function", new Object[0]);
        return f.compose(g);
    }

    public static <T1, T2, T3, R> Function<T1, R> compose(Function<T3, R> f, Function<T2, T3> g, Function<T1, T2> h) {
        dbc.precondition(f != null, "cannot compose a null function", new Object[0]);
        dbc.precondition(g != null, "cannot compose a null function", new Object[0]);
        dbc.precondition(h != null, "cannot compose a null function", new Object[0]);
        return f.compose(g.compose(h));
    }

    public static <T1, T2, T3, R> BiFunction<T1, T2, R> compose(Function<T3, R> unary, BiFunction<T1, T2, T3> binary) {
        dbc.precondition(unary != null, "cannot compose a null unary function", new Object[0]);
        dbc.precondition(binary != null, "cannot compose a null binary function", new Object[0]);
        return binary.andThen(unary);
    }

    public static <T1, T2, T3, T4, R> TriFunction<T1, T2, T3, R> compose(Function<T4, R> unary, TriFunction<T1, T2, T3, T4> ternary) {
        dbc.precondition(unary != null, "cannot compose a null unary function", new Object[0]);
        dbc.precondition(ternary != null, "cannot compose a null ternary function", new Object[0]);
        return ternary.andThen(unary);
    }

    public static <T, R> Predicate<T> compose(Predicate<R> predicate, Function<T, R> function) {
        dbc.precondition(predicate != null, "cannot compose function with a null predicate", new Object[0]);
        dbc.precondition(function != null, "cannot compose predicate with a null function", new Object[0]);
        return t -> predicate.test(function.apply(t));
    }

    public static <R, T1, T2> BiPredicate<T1, T2> compose(Predicate<R> predicate, BiFunction<T1, T2, R> function) {
        dbc.precondition(predicate != null, "cannot compose function with a null predicate", new Object[0]);
        dbc.precondition(function != null, "cannot compose predicate with a null binary function", new Object[0]);
        return (t1, t2) -> predicate.test(function.apply(t1, t2));
    }

    public static <T1, T2, T3, R> TriPredicate<T1, T2, T3> compose(Predicate<R> predicate, TriFunction<T1, T2, T3, R> function) {
        dbc.precondition(predicate != null, "cannot compose function with a null predicate", new Object[0]);
        dbc.precondition(function != null, "cannot compose predicate with a null ternary function", new Object[0]);
        return (t1, t2, t3) -> predicate.test(function.apply(t1, t2, t3));
    }

    public static <T> UnaryOperator<T> compose(Iterator<Function<T, T>> endodelegates) {
        return new UnaryOperatorsComposer<T>().apply(endodelegates);
    }
}

