/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.windows;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class CenteredWindowIterator<W extends Collection<Optional<T>>, T>
extends ReadOnlyIterator<W> {
    private final Iterator<T> iter;
    private final int windowSize;
    private final Supplier<W> supplier;
    private final LinkedList<Optional<T>> window = new LinkedList();
    private boolean freshIterator = true;

    public CenteredWindowIterator(Iterator<T> iter, int windowSize, Supplier<W> supplier) {
        dbc.precondition(iter != null, "cannot create a CenteredWindowIterator with a null iterator", new Object[0]);
        dbc.precondition(windowSize > 2, "cannot create a CenteredWindowIterator with a non positive or 1 window size", new Object[0]);
        dbc.precondition(windowSize % 2 == 1, "cannot create a CenteredWindowIterator with an even windowSize", new Object[0]);
        dbc.precondition(supplier != null, "cannot create a CenteredWindowIterator with an null supplier", new Object[0]);
        this.iter = iter;
        this.windowSize = windowSize;
        this.supplier = supplier;
        for (int i = 0; i != windowSize / 2; ++i) {
            this.window.add(Optional.empty());
        }
    }

    @Override
    public boolean hasNext() {
        this.fillWindow();
        return !this.isConsumed();
    }

    @Override
    public W next() {
        this.fillWindow();
        if (this.isConsumed()) {
            throw new NoSuchElementException("iterator is consumed");
        }
        if (!this.freshIterator) {
            this.window.remove();
        }
        this.freshIterator = false;
        this.fillWindow();
        Collection collection = (Collection)this.supplier.get();
        collection.addAll(this.window);
        return (W)collection;
    }

    private boolean isConsumed() {
        if (this.freshIterator) {
            return !this.center().isPresent();
        }
        return !this.nextOfCenter().isPresent();
    }

    private Optional<T> nextOfCenter() {
        return this.window.get(this.windowSize / 2 + 1);
    }

    private Optional<T> center() {
        return this.window.get(this.windowSize / 2);
    }

    private void fillWindow() {
        while (this.window.size() != this.windowSize) {
            Optional maybe = this.iter.hasNext() ? Optional.of(this.iter.next()) : Optional.empty();
            this.window.add(maybe);
        }
    }
}

