/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.time;

import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import net.emaze.dysfunctional.time.SleepInterruptedException;
import net.emaze.dysfunctional.time.TimeStrategy;
import net.emaze.dysfunctional.tuples.Pair;

public class SleepAtLeast
implements BiConsumer<Long, TimeUnit> {
    private final TimeStrategy time;

    public SleepAtLeast(TimeStrategy time) {
        this.time = time;
    }

    @Override
    public void accept(Long duration, TimeUnit unit) {
        Pair<Long, TimeUnit> slept = this.sleep(duration, unit);
        for (long elapsedInStrategyUnit = slept.first().longValue(); elapsedInStrategyUnit < slept.second().convert(duration, unit); elapsedInStrategyUnit += slept.first().longValue()) {
            slept = this.sleep(slept.second().convert(duration, unit) - elapsedInStrategyUnit, unit);
        }
    }

    private Pair<Long, TimeUnit> sleep(long duration, TimeUnit unit) {
        Pair<Long, TimeUnit> start = this.time.currentTime();
        try {
            this.time.sleep(duration, unit);
            return Pair.of(start.second().convert(duration, unit), start.second());
        }
        catch (SleepInterruptedException ex) {
            Pair<Long, TimeUnit> now = this.time.currentTime();
            return Pair.of(now.first() - start.first(), now.second());
        }
    }
}

