/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import java.util.Optional;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class LongTryParser
implements Function<String, Optional<Long>> {
    private final int radix;

    public LongTryParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Optional<Long> apply(String parsee) {
        try {
            return Optional.of(Long.parseLong(parsee, this.radix));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

