/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strings.lexcasts;

import java.util.Optional;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;

public class IntegerTryParser
implements Function<String, Optional<Integer>> {
    private final int radix;

    public IntegerTryParser(int radix) {
        dbc.precondition(radix >= 2, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        dbc.precondition(radix <= 36, "radix should be in range [MIN_RADIX, MAX_RADIX]", new Object[0]);
        this.radix = radix;
    }

    @Override
    public Optional<Integer> apply(String parsee) {
        try {
            return Optional.of(Integer.parseInt(parsee, this.radix));
        }
        catch (NumberFormatException ex) {
            return Optional.empty();
        }
    }
}

