/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strategies;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.strategies.Clause;

public class MaybeFirstMatchStrategy<T, R>
implements Function<T, Optional<R>> {
    private final List<Clause<T, R>> clauses;

    public MaybeFirstMatchStrategy(List<Clause<T, R>> clauses) {
        dbc.precondition(clauses != null, "clauses cannot be null", new Object[0]);
        this.clauses = clauses;
    }

    @Override
    public Optional<R> apply(T t) {
        return this.clauses.stream().filter(clause -> clause.condition.test(t)).map(clause -> clause.body.apply(t)).findFirst();
    }
}

