/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.strategies;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.strategies.Clause;

public class AllMatchesStrategy<T, R>
implements Function<T, List<R>> {
    private final List<Clause<T, R>> clauses;

    public AllMatchesStrategy(List<Clause<T, R>> clauses) {
        dbc.precondition(clauses != null, "clauses cannot be null", new Object[0]);
        this.clauses = clauses;
    }

    @Override
    public List<R> apply(T t) {
        return this.clauses.stream().filter(clause -> clause.condition.test(t)).map(clause -> clause.body.apply(t)).collect(Collectors.toList());
    }
}

