/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.reductions;

import java.util.Iterator;
import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;

public class Every<T>
implements Predicate<Iterator<T>> {
    private final Predicate<T> predicate;

    public Every(Predicate<T> predicate) {
        dbc.precondition(predicate != null, "cannot create Every with a null predicate", new Object[0]);
        this.predicate = predicate;
    }

    @Override
    public boolean test(Iterator<T> iterator) {
        dbc.precondition(iterator != null, "cannot call Every with a null iterator", new Object[0]);
        while (iterator.hasNext()) {
            if (this.predicate.test(iterator.next())) continue;
            return false;
        }
        return true;
    }
}

