/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.ranges;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;
import net.emaze.dysfunctional.order.Order;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.ranges.RangeComparator;
import net.emaze.dysfunctional.ranges.RangeIterator;

public class DenseRange<T>
implements Range<T> {
    private final SequencingPolicy<T> sequencer;
    private final Comparator<Optional<T>> comparator;
    private final T begin;
    private final Optional<T> end;

    public DenseRange(SequencingPolicy<T> sequencer, Comparator<Optional<T>> comparator, Range.Endpoint left, T lower, Optional<T> upper, Range.Endpoint right) {
        dbc.precondition(sequencer != null, "trying to create a DenseRange<T> with a null SequencingPolicy<T>", new Object[0]);
        dbc.precondition(comparator != null, "trying to create a DenseRange<T> with a null Comparator<T>", new Object[0]);
        dbc.precondition(lower != null, "trying to create a DenseRange<T> with null lower bound", new Object[0]);
        dbc.precondition(upper != null, "trying to create a DenseRange<T> with null upper bound", new Object[0]);
        dbc.precondition(Order.of(comparator, Optional.of(lower), upper) != Order.GT, "trying to create a DenseRange<T> a lower bound greater than upper bound", new Object[0]);
        dbc.precondition(upper.isPresent() || right != Range.Endpoint.Include, "cannot create a right inclusive range with right bound set as Nothing", new Object[0]);
        this.sequencer = sequencer;
        this.comparator = comparator;
        this.begin = left == Range.Endpoint.Include ? lower : sequencer.next(lower).get();
        this.end = upper.isPresent() && right == Range.Endpoint.Include ? sequencer.next(upper.get()) : upper;
    }

    @Override
    public boolean contains(T element) {
        return Order.of(this.comparator, Optional.of(element), Optional.of(this.begin)).isGte() && Order.of(this.comparator, Optional.of(element), this.end).isLt();
    }

    @Override
    public T begin() {
        return this.begin;
    }

    @Override
    public Optional<T> end() {
        return this.end;
    }

    @Override
    public int compareTo(Range<T> other) {
        dbc.precondition(other != null, "comparing (compareTo) a DenseRange<T> with null", new Object[0]);
        return new RangeComparator<T>(this.comparator).compare(this, other);
    }

    @Override
    public Iterator<T> iterator() {
        return new RangeIterator<T>(this.sequencer, this.comparator, this.begin, this.end);
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof DenseRange)) {
            return false;
        }
        DenseRange other = (DenseRange)rhs;
        EqualsBuilder builder = new EqualsBuilder().append(this.sequencer, other.sequencer).append(this.comparator, other.comparator);
        if (!this.iterator().hasNext() && !other.iterator().hasNext()) {
            return builder.isEquals();
        }
        return builder.append(this.begin, other.begin).append(this.end, other.end).isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append(this.sequencer).append(this.comparator);
        if (!this.iterator().hasNext()) {
            return builder.toHashCode();
        }
        return builder.append(this.begin).append(this.end).toHashCode();
    }

    public String toString() {
        return String.format("[%s-%s)", this.begin, this.end.isPresent() ? this.end.get() : "...");
    }

    @Override
    public boolean overlaps(Range<T> other) {
        dbc.precondition(other != null, "checking for overlaps between a DenseRange<T> and null", new Object[0]);
        if (!(other instanceof DenseRange)) {
            return other.overlaps(this);
        }
        return !Order.of(this.comparator, Optional.of(this.begin()), other.end()).isGte() && !Order.of(this.comparator, Optional.of(other.begin()), this.end()).isGte();
    }

    @Override
    public List<DenseRange<T>> densified() {
        return Collections.singletonList(this);
    }
}

