/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.order;

import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.order.PeriodicSequencingPolicy;

public class PeriodicIterator<T>
extends ReadOnlyIterator<T> {
    private final PeriodicSequencingPolicy<T> sequencer;
    private T next;

    public PeriodicIterator(PeriodicSequencingPolicy<T> sequencer, T start) {
        dbc.precondition(sequencer != null, "cannot create a PeriodicIterator witha null sequencer", new Object[0]);
        this.sequencer = sequencer;
        this.next = start;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public T next() {
        T result = this.next;
        this.next = this.sequencer.next(this.next).get();
        return result;
    }
}

