/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.options;

import java.util.Optional;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.equality.EqualsBuilder;
import net.emaze.dysfunctional.hashing.HashCodeBuilder;

public class Either<LT, RT> {
    private final Optional<LT> left;
    private final Optional<RT> right;

    public Either(Optional<LT> left, Optional<RT> right) {
        dbc.precondition(left != null, "cannot create Either with null left", new Object[0]);
        dbc.precondition(right != null, "cannot create Either with null right", new Object[0]);
        dbc.precondition(left.isPresent() != right.isPresent(), "Either left or right must have a value", new Object[0]);
        this.left = left;
        this.right = right;
    }

    public <LR, RR> Either<LR, RR> map(Function<LT, LR> withLeft, Function<RT, RR> withRight) {
        dbc.precondition(withLeft != null, "cannot fmap an either with a null left function", new Object[0]);
        dbc.precondition(withRight != null, "cannot fmap an either with a null right function", new Object[0]);
        if (this.left.isPresent()) {
            return Either.left(withLeft.apply(this.left.get()));
        }
        return Either.right(withRight.apply(this.right.get()));
    }

    public <T> T fold(Function<LT, T> withLeft, Function<RT, T> withRight) {
        dbc.precondition(withLeft != null, "cannot fold an either with a null left function", new Object[0]);
        dbc.precondition(withRight != null, "cannot fold an either with a null right function", new Object[0]);
        if (this.left.isPresent()) {
            return withLeft.apply(this.left.get());
        }
        return withRight.apply(this.right.get());
    }

    public Optional<LT> left() {
        return this.left;
    }

    public Optional<RT> right() {
        return this.right;
    }

    public Either<RT, LT> flip() {
        return new Either<RT, LT>(this.right, this.left);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.left).append(this.right).toHashCode();
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof Either)) {
            return false;
        }
        Either other = (Either)rhs;
        return new EqualsBuilder().append(this.left, other.left).append(this.right, other.right).isEquals();
    }

    public String toString() {
        if (this.left.isPresent()) {
            return String.format("Left %s", this.left.get());
        }
        return String.format("Right %s", this.right.get());
    }

    public static <T1, T2> Either<T1, T2> left(T1 left) {
        dbc.precondition(left != null, "cannot create Either with null left value", new Object[0]);
        return new Either(Optional.of(left), Optional.empty());
    }

    public static <T1, T2> Either<T1, T2> right(T2 right) {
        dbc.precondition(right != null, "cannot create Either with null right value", new Object[0]);
        return new Either(Optional.empty(), Optional.of(right));
    }
}

