/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.OptionalIterator;

public class UnchainLongestIterator<C extends Collection<Optional<T>>, T>
extends ReadOnlyIterator<C> {
    private final Iterator<Optional<T>> iterator;
    private final Supplier<Optional<Integer>> channelsSizesProvider;
    private final Supplier<C> channelProvider;

    public UnchainLongestIterator(Supplier<Optional<Integer>> channelsSizesProvider, Iterator<T> iterator, Supplier<C> channelProvider) {
        dbc.precondition(channelsSizesProvider != null, "cannot build a UnchainLongestIterator with channelsSizesProvider < 1", new Object[0]);
        dbc.precondition(iterator != null, "cannot build a UnchainLongestIterator with a null iterator", new Object[0]);
        dbc.precondition(channelProvider != null, "cannot build a UnchainLongestIterator with a null channelProvider", new Object[0]);
        this.iterator = new OptionalIterator<T>(iterator);
        this.channelsSizesProvider = channelsSizesProvider;
        this.channelProvider = channelProvider;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public C next() {
        Collection out = (Collection)this.channelProvider.get();
        Optional<Integer> maybeChannelSize = this.channelsSizesProvider.get();
        dbc.state(maybeChannelSize.isPresent(), "unexpected channel size request (supplier returned Nothing)", new Object[0]);
        int channelSize = maybeChannelSize.get();
        for (int i = 0; i != channelSize; ++i) {
            out.add(this.iterator.next());
        }
        return (C)out;
    }
}

