/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.multiplexing;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;
import net.emaze.dysfunctional.options.Box;

public class UnchainIterator<C extends Collection<T>, T>
extends ReadOnlyIterator<C> {
    private final Iterator<T> iterator;
    private final int channelSize;
    private final Supplier<C> channelProvider;
    private final Box<C> prefetched = Box.empty();

    public UnchainIterator(int channelSize, Iterator<T> iterator, Supplier<C> channelProvider) {
        dbc.precondition(channelSize > 0, "max channel size must be > 0", new Object[0]);
        dbc.precondition(iterator != null, "iterator cannot be null", new Object[0]);
        dbc.precondition(channelProvider != null, "channelProvider cannot be null", new Object[0]);
        this.iterator = iterator;
        this.channelSize = channelSize;
        this.channelProvider = channelProvider;
    }

    @Override
    public boolean hasNext() {
        if (this.prefetched.isEmpty()) {
            this.prefetched.setContent(this.prefetch(this.iterator, this.channelSize));
        }
        return ((Collection)this.prefetched.getContent()).size() != 0;
    }

    @Override
    public C next() {
        if (this.prefetched.isEmpty()) {
            this.prefetched.setContent(this.prefetch(this.iterator, this.channelSize));
        }
        if (((Collection)this.prefetched.getContent()).size() == 0) {
            throw new NoSuchElementException();
        }
        return (C)((Collection)this.prefetched.unload().get());
    }

    private C prefetch(Iterator<T> iter, int size) {
        Collection result = (Collection)this.channelProvider.get();
        for (int counter = 0; counter != size && iter.hasNext(); ++counter) {
            result.add(iter.next());
        }
        return (C)result;
    }
}

