/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.interceptions;

import java.util.Iterator;
import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.interceptions.Interceptor;
import net.emaze.dysfunctional.interceptions.InterceptorAdapter;

public class InterceptorChain<T, R>
implements Function<T, R> {
    private final Function<T, R> composed;

    public <I extends Interceptor<T>> InterceptorChain(Function<T, R> innermost, Iterator<I> chain) {
        dbc.precondition(innermost != null, "innermost function cannot be null", new Object[0]);
        dbc.precondition(chain != null, "chain cannot be null", new Object[0]);
        Function<T, R> current = innermost;
        while (chain.hasNext()) {
            current = new InterceptorAdapter<T, R>((Interceptor)chain.next(), current);
        }
        this.composed = current;
    }

    @Override
    public R apply(T param) {
        return this.composed.apply(param);
    }
}

