/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.filtering;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.emaze.dysfunctional.contracts.dbc;

public class TakeUpToIterator<E>
implements Iterator<E> {
    private final Iterator<E> iterator;
    private long left;

    public TakeUpToIterator(Iterator<E> iterator, long howMany) {
        dbc.precondition(iterator != null, "trying to create a TakeUpToIterator from a null iterator", new Object[0]);
        dbc.precondition(howMany >= 0L, "trying to create a TakeUpToIterator from a negative howMany", new Object[0]);
        this.iterator = iterator;
        this.left = howMany;
    }

    @Override
    public boolean hasNext() {
        return this.left != 0L && this.iterator.hasNext();
    }

    @Override
    public E next() {
        if (this.left == 0L) {
            throw new NoSuchElementException();
        }
        E el = this.iterator.next();
        --this.left;
        return el;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

