/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.filtering;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ReadOnlyIterator;

public class AtMostMemoryIterator<T>
extends ReadOnlyIterator<T> {
    private final Iterator<T> iterator;
    private final int memorySize;
    private Queue<T> memory;
    private boolean hasMemory;

    public AtMostMemoryIterator(Iterator<T> iterator, int memorySize) {
        dbc.precondition(iterator != null, "creating a MemoryIterator with a null iterator", new Object[0]);
        dbc.precondition(memorySize > 0, "creating a MemoryIterator with a non positive memorySize", new Object[0]);
        this.iterator = iterator;
        this.memorySize = memorySize;
    }

    @Override
    public boolean hasNext() {
        if (!this.hasMemory) {
            this.memory = AtMostMemoryIterator.fetch(this.iterator, this.memorySize);
            this.hasMemory = true;
        }
        return !this.memory.isEmpty();
    }

    @Override
    public T next() {
        if (!this.hasMemory) {
            this.memory = AtMostMemoryIterator.fetch(this.iterator, this.memorySize);
            this.hasMemory = true;
        }
        return this.memory.remove();
    }

    private static <T> Queue<T> fetch(Iterator<T> iterator, int size) {
        LinkedList<T> mem = new LinkedList<T>();
        while (iterator.hasNext()) {
            T element = iterator.next();
            mem.add(element);
            if (mem.size() <= size) continue;
            mem.remove();
        }
        return mem;
    }
}

