/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import net.emaze.dysfunctional.contracts.dbc;

public class MonitoringConsumer<T>
implements Consumer<T> {
    private final Consumer<T> nested;
    private final AtomicLong calls;

    public MonitoringConsumer(Consumer<T> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null consumer", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public void accept(T value) {
        this.calls.incrementAndGet();
        this.nested.accept(value);
    }
}

