/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.function.Function;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.options.Box;

public class CapturingFunction<T, R>
implements Function<T, R> {
    private final Function<T, R> nested;
    private final Box<R> result;
    private final Box<T> param;

    public CapturingFunction(Function<T, R> nested, Box<R> result, Box<T> param) {
        dbc.precondition(nested != null, "cannot capture from a null function", new Object[0]);
        dbc.precondition(result != null, "cannot capture with a null result box", new Object[0]);
        dbc.precondition(param != null, "cannot capture with a null param box", new Object[0]);
        this.nested = nested;
        this.result = result;
        this.param = param;
    }

    @Override
    public R apply(T value) {
        this.param.setContent(value);
        R got = this.nested.apply(value);
        this.result.setContent(got);
        return got;
    }
}

