/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import net.emaze.dysfunctional.contracts.dbc;

public class BinaryMonitoringPredicate<T1, T2>
implements BiPredicate<T1, T2> {
    private final BiPredicate<T1, T2> nested;
    private final AtomicLong calls;

    public BinaryMonitoringPredicate(BiPredicate<T1, T2> nested, AtomicLong calls) {
        dbc.precondition(nested != null, "cannot monitor a null predicate", new Object[0]);
        dbc.precondition(calls != null, "cannot monitor with a null AtomicLong", new Object[0]);
        this.nested = nested;
        this.calls = calls;
    }

    @Override
    public boolean test(T1 former, T2 latter) {
        this.calls.incrementAndGet();
        return this.nested.test(former, latter);
    }
}

