/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.dispatching.spying;

import java.util.function.BiConsumer;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.options.Box;

public class BinaryCapturingConsumer<T1, T2>
implements BiConsumer<T1, T2> {
    private final BiConsumer<T1, T2> nested;
    private final Box<T1> param1;
    private final Box<T2> param2;

    public BinaryCapturingConsumer(BiConsumer<T1, T2> nested, Box<T1> param1, Box<T2> param2) {
        dbc.precondition(nested != null, "cannot capture from a null consumer", new Object[0]);
        dbc.precondition(param1 != null, "cannot capture with a null param1 box", new Object[0]);
        dbc.precondition(param2 != null, "cannot capture from a null param2 box", new Object[0]);
        this.nested = nested;
        this.param1 = param1;
        this.param2 = param2;
    }

    @Override
    public void accept(T1 former, T2 latter) {
        this.param1.setContent(former);
        this.param2.setContent(latter);
        this.nested.accept(former, latter);
    }
}

