/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional.convolutions;

import java.util.Iterator;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.tuples.Pair;

public class ZipShortestIterator<E1, E2>
implements Iterator<Pair<E1, E2>> {
    private final Iterator<E1> former;
    private final Iterator<E2> latter;

    public ZipShortestIterator(Iterator<E1> former, Iterator<E2> latter) {
        dbc.precondition(former != null, "trying to create a ZipShortestIterator from a null iterator (former)", new Object[0]);
        dbc.precondition(latter != null, "trying to create a ZipShortestIterator from a null iterator (latter)", new Object[0]);
        this.former = former;
        this.latter = latter;
    }

    @Override
    public boolean hasNext() {
        return this.former.hasNext() && this.latter.hasNext();
    }

    @Override
    public Pair<E1, E2> next() {
        return Pair.of(this.former.next(), this.latter.next());
    }

    @Override
    public void remove() {
        this.former.remove();
        this.latter.remove();
    }
}

