/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.emaze.dysfunctional.Filtering;
import net.emaze.dysfunctional.collections.ArrayListFactory;
import net.emaze.dysfunctional.consumers.ConsumeIntoCollection;
import net.emaze.dysfunctional.consumers.FirstElement;
import net.emaze.dysfunctional.consumers.LastElement;
import net.emaze.dysfunctional.consumers.MaybeFirstElement;
import net.emaze.dysfunctional.consumers.MaybeLastElement;
import net.emaze.dysfunctional.consumers.MaybeOneElement;
import net.emaze.dysfunctional.consumers.OneElement;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.delegates.ConstantSupplier;
import net.emaze.dysfunctional.filtering.FilteringIterator;
import net.emaze.dysfunctional.iterations.ArrayIterator;

public abstract class Searches {
    public static <E> List<E> search(Iterator<E> iterator, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return (List)consumer.apply(filtered);
    }

    public static <C extends Collection<E>, E> C search(Iterator<E> iterator, C collection, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantSupplier<C>(collection));
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return (C)((Collection)consumer.apply(filtered));
    }

    public static <C extends Collection<E>, E> C search(Iterator<E> iterator, Supplier<C> supplier, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(supplier);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return (C)((Collection)consumer.apply(filtered));
    }

    public static <E> List<E> search(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot search a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return (List)consumer.apply(filtered);
    }

    public static <C extends Collection<E>, E> C search(Iterable<E> iterable, C collection, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot search a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantSupplier<C>(collection));
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return (C)((Collection)consumer.apply(filtered));
    }

    public static <C extends Collection<E>, E> C search(Iterable<E> iterable, Supplier<C> supplier, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot search a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(supplier);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return (C)((Collection)consumer.apply(filtered));
    }

    public static <E> List<E> search(E[] array, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return (List)consumer.apply(filtered);
    }

    public static <C extends Collection<E>, E> C search(E[] array, C collection, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantSupplier<C>(collection));
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return (C)((Collection)consumer.apply(filtered));
    }

    public static <C extends Collection<E>, E> C search(E[] array, Supplier<C> supplier, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(supplier);
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return (C)((Collection)consumer.apply(filtered));
    }

    public static <E> List<E> find(Iterator<E> iterator, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        ArrayList found = (ArrayList)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return found;
    }

    public static <C extends Collection<E>, E> C find(Iterator<E> iterator, C collection, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantSupplier<C>(collection));
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        Collection found = (Collection)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return (C)found;
    }

    public static <C extends Collection<E>, E> C find(Iterator<E> iterator, Supplier<C> supplier, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(supplier);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        Collection found = (Collection)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return (C)found;
    }

    public static <E> List<E> find(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot search a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        ArrayList found = (ArrayList)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return found;
    }

    public static <C extends Collection<E>, E> C find(Iterable<E> iterable, C collection, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot search a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantSupplier<C>(collection));
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        Collection found = (Collection)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return (C)found;
    }

    public static <C extends Collection<E>, E> C find(Iterable<E> iterable, Supplier<C> supplier, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot search a null iterable", new Object[0]);
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(supplier);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        Collection found = (Collection)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return (C)found;
    }

    public static <E> List<E> find(E[] array, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ArrayListFactory());
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        ArrayList found = (ArrayList)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return found;
    }

    public static <C extends Collection<E>, E> C find(E[] array, C collection, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(new ConstantSupplier<C>(collection));
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        Collection found = (Collection)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return (C)found;
    }

    public static <C extends Collection<E>, E> C find(E[] array, Supplier<C> supplier, Predicate<E> predicate) {
        ConsumeIntoCollection consumer = new ConsumeIntoCollection(supplier);
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        Collection found = (Collection)consumer.apply(filtered);
        dbc.precondition(!found.isEmpty(), "no element matched", new Object[0]);
        return (C)found;
    }

    public static <E> Optional<E> searchFirst(E[] array, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return new MaybeFirstElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchFirst(Iterator<E> iterator, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return new MaybeFirstElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchFirst(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot searchFirst with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return new MaybeFirstElement<E>().apply(filtered);
    }

    public static <E> E findFirst(Iterator<E> iterator, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return new FirstElement<E>().apply(filtered);
    }

    public static <E> E findFirst(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot findFirst with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return new FirstElement<E>().apply(filtered);
    }

    public static <E> E findFirst(E[] array, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return new FirstElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchOne(Iterator<E> iterator, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return new MaybeOneElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchOne(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot searchOne with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return new MaybeOneElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchOne(E[] array, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return new MaybeOneElement<E>().apply(filtered);
    }

    public static <E> E findOne(Iterator<E> iterator, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return new OneElement<E>().apply(filtered);
    }

    public static <E> E findOne(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot findOne with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return new OneElement<E>().apply(filtered);
    }

    public static <E> E findOne(E[] array, Predicate<E> predicate) {
        Iterator<E> filtered = Filtering.filter(new ArrayIterator<E>(array), predicate);
        return new OneElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchLast(Iterator<E> iterator, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return new MaybeLastElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchLast(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot searchLast with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return new MaybeLastElement<E>().apply(filtered);
    }

    public static <E> Optional<E> searchLast(E[] array, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return new MaybeLastElement<E>().apply(filtered);
    }

    public static <E> E findLast(Iterator<E> iterator, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterator, predicate);
        return new LastElement<E>().apply(filtered);
    }

    public static <E> E findLast(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot searchLast with a null iterable", new Object[0]);
        FilteringIterator<E> filtered = new FilteringIterator<E>(iterable.iterator(), predicate);
        return new LastElement<E>().apply(filtered);
    }

    public static <E> E findLast(E[] array, Predicate<E> predicate) {
        FilteringIterator<E> filtered = new FilteringIterator<E>(new ArrayIterator<E>(array), predicate);
        return new LastElement<E>().apply(filtered);
    }
}

