/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.order.ComparableComparator;
import net.emaze.dysfunctional.reductions.Any;
import net.emaze.dysfunctional.reductions.Count;
import net.emaze.dysfunctional.reductions.Every;
import net.emaze.dysfunctional.reductions.Reductor;

public abstract class Reductions {
    public static <E, R> R reduce(Iterator<E> iterator, BiFunction<R, E, R> function, R init) {
        return new Reductor<E, R>(function, init).apply(iterator);
    }

    public static <E, R> R reduce(Iterable<E> iterable, BiFunction<R, E, R> function, R init) {
        dbc.precondition(iterable != null, "cannot call reduce with a null iterable", new Object[0]);
        return new Reductor<E, R>(function, init).apply(iterable.iterator());
    }

    public static <E, R> R reduce(E[] array, BiFunction<R, E, R> function, R init) {
        return new Reductor<E, R>(function, init).apply((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> boolean any(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot call any with a null iterable", new Object[0]);
        return new Any<E>(predicate).test(iterable.iterator());
    }

    public static <E> boolean any(Iterator<E> iterator, Predicate<E> predicate) {
        return new Any<E>(predicate).test(iterator);
    }

    public static <E> boolean any(E[] array, Predicate<E> predicate) {
        return new Any<E>(predicate).test((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> boolean every(Iterable<E> iterable, Predicate<E> predicate) {
        dbc.precondition(iterable != null, "cannot call every with a null iterable", new Object[0]);
        return new Every<E>(predicate).test(iterable.iterator());
    }

    public static <E> boolean every(Iterator<E> iterator, Predicate<E> predicate) {
        return new Every<E>(predicate).test(iterator);
    }

    public static <E> boolean every(E[] array, Predicate<E> predicate) {
        return new Every<E>(predicate).test((Iterator<E>)new ArrayIterator<E>(array));
    }

    public static <E> long count(Iterator<E> iterator) {
        return Reductions.reduce(iterator, new Count(), Long.valueOf(0L));
    }

    public static <E> long count(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call count with a null iterable", new Object[0]);
        return Reductions.count(iterable.iterator());
    }

    public static <E> int counti(Iterator<E> iterator) {
        long value = Reductions.reduce(iterator, new Count(), Long.valueOf(0L));
        dbc.state(value <= Integer.MAX_VALUE, "iterator size overflows an integer", new Object[0]);
        return (int)value;
    }

    public static <E> int counti(Iterable<E> iterable) {
        dbc.precondition(iterable != null, "cannot call counti with a null iterable", new Object[0]);
        return Reductions.counti(iterable.iterator());
    }

    public static <E, C extends Comparator<E>> E maximum(Iterator<E> iterator, C comparator, E init) {
        return Reductions.reduce(iterator, BinaryOperator.maxBy(comparator), init);
    }

    public static <E extends Comparable<E>> E maximum(Iterator<E> iterator, E init) {
        return Reductions.reduce(iterator, BinaryOperator.maxBy(new ComparableComparator()), init);
    }

    public static <E, C extends Comparator<E>> E minimum(Iterator<E> iterator, C comparator, E init) {
        return Reductions.reduce(iterator, BinaryOperator.minBy(comparator), init);
    }

    public static <E extends Comparable<E>> E minimum(Iterator<E> iterator, E init) {
        return Reductions.reduce(iterator, BinaryOperator.minBy(new ComparableComparator()), init);
    }
}

