/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.order.JustBeforeNothingComparator;
import net.emaze.dysfunctional.order.SequencingPolicy;
import net.emaze.dysfunctional.ranges.DenseRange;
import net.emaze.dysfunctional.ranges.Difference;
import net.emaze.dysfunctional.ranges.Intersection;
import net.emaze.dysfunctional.ranges.Range;
import net.emaze.dysfunctional.ranges.SymmetricDifference;
import net.emaze.dysfunctional.ranges.Union;
import net.emaze.dysfunctional.reductions.Reductor;

public class Ranges<T> {
    private final Comparator<Optional<T>> comparator;
    private final SequencingPolicy<T> sequencer;
    private final T emptyValue;

    public Ranges(Comparator<T> comparator, SequencingPolicy<T> sequencer, T emptyValue) {
        dbc.precondition(comparator != null, "cannot create Ranges<T> with a null Comparator<T>", new Object[0]);
        dbc.precondition(sequencer != null, "cannot create Ranges<T> with a null SequencingPolicy<T>", new Object[0]);
        this.comparator = new JustBeforeNothingComparator<T>(comparator);
        this.sequencer = sequencer;
        this.emptyValue = emptyValue;
    }

    public Range<T> of(Range.Endpoint left, T lower, Optional<T> upper, Range.Endpoint right) {
        return new DenseRange<T>(this.sequencer, this.comparator, left, lower, upper, right);
    }

    public Range<T> rightHalfOpen(T lower, Optional<T> upper) {
        return new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, lower, upper, Range.Endpoint.Exclude);
    }

    public Range<T> leftHalfOpen(T lower, T upper) {
        return new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Exclude, lower, Optional.of(upper), Range.Endpoint.Include);
    }

    public Range<T> open(T lower, T upper) {
        return new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Exclude, lower, Optional.of(upper), Range.Endpoint.Exclude);
    }

    public Range<T> closed(T lower, T upper) {
        return new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, lower, Optional.of(upper), Range.Endpoint.Include);
    }

    public Range<T> degenerate(T value) {
        return new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, value, Optional.of(value), Range.Endpoint.Include);
    }

    public Range<T> empty() {
        return new DenseRange<T>(this.sequencer, this.comparator, Range.Endpoint.Include, this.emptyValue, Optional.of(this.emptyValue), Range.Endpoint.Exclude);
    }

    public Range<T> union(Range<T> lhs, Range<T> rhs) {
        Union<T> union = new Union<T>(this.sequencer, this.comparator, this.emptyValue);
        return union.apply(lhs, rhs);
    }

    public Range<T> union(Range<T> first, Range<T> second, Range<T> third) {
        Union<T> union = new Union<T>(this.sequencer, this.comparator, this.emptyValue);
        return union.apply(union.apply(first, second), third);
    }

    public Range<T> union(Iterator<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot evaluate union for a null iterator of ranges", new Object[0]);
        dbc.precondition(ranges.hasNext(), "cannot evaluate union for an empty iterator of ranges", new Object[0]);
        Union<T> union = new Union<T>(this.sequencer, this.comparator, this.emptyValue);
        return new Reductor<Range<T>, Range<T>>(union, ranges.next()).apply(ranges);
    }

    public Range<T> union(Iterable<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot evaluate union for a null iterable of ranges", new Object[0]);
        dbc.precondition(ranges.iterator().hasNext(), "cannot evaluate union for an empty iterable of ranges", new Object[0]);
        Iterator<Range<T>> iterator = ranges.iterator();
        Union<T> union = new Union<T>(this.sequencer, this.comparator, this.emptyValue);
        return new Reductor<Range<T>, Range<T>>(union, iterator.next()).apply(iterator);
    }

    public Range<T> union(Range<T> ... ranges) {
        dbc.precondition(ranges != null, "cannot evaluate union for a null array of ranges", new Object[0]);
        dbc.precondition(ranges.length != 0, "cannot evaluate union for an empty array of ranges", new Object[0]);
        ArrayIterator<Range<T>> iterator = new ArrayIterator<Range<T>>(ranges);
        Union<T> union = new Union<T>(this.sequencer, this.comparator, this.emptyValue);
        return (Range)new Reductor<Range<T>, Range<T>>(union, iterator.next()).apply((Iterator<Range<T>>)iterator);
    }

    public Range<T> intersect(Range<T> lhs, Range<T> rhs) {
        Intersection<T> intersection = new Intersection<T>(this.sequencer, this.comparator, this.emptyValue);
        return intersection.apply(lhs, rhs);
    }

    public Range<T> intersect(Range<T> first, Range<T> second, Range<T> third) {
        Intersection<T> intersection = new Intersection<T>(this.sequencer, this.comparator, this.emptyValue);
        return intersection.apply(intersection.apply(first, second), third);
    }

    public Range<T> intersect(Iterator<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot intersection a null iterator of ranges", new Object[0]);
        dbc.precondition(ranges.hasNext(), "cannot intersection an empty iterator of ranges", new Object[0]);
        Intersection<T> intersection = new Intersection<T>(this.sequencer, this.comparator, this.emptyValue);
        return new Reductor<Range<T>, Range<T>>(intersection, ranges.next()).apply(ranges);
    }

    public Range<T> intersect(Iterable<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot intersect a null iterable of ranges", new Object[0]);
        dbc.precondition(ranges.iterator().hasNext(), "cannot intersect an empty iterable of ranges", new Object[0]);
        Intersection<T> intersection = new Intersection<T>(this.sequencer, this.comparator, this.emptyValue);
        Iterator<Range<T>> iterator = ranges.iterator();
        return new Reductor<Range<T>, Range<T>>(intersection, iterator.next()).apply(iterator);
    }

    public Range<T> intersect(Range<T> ... ranges) {
        dbc.precondition(ranges != null, "cannot intersect a null array of ranges", new Object[0]);
        dbc.precondition(ranges.length != 0, "cannot intersect an empty array of ranges", new Object[0]);
        Intersection<T> intersection = new Intersection<T>(this.sequencer, this.comparator, this.emptyValue);
        ArrayIterator<Range<T>> iterator = new ArrayIterator<Range<T>>(ranges);
        return (Range)new Reductor<Range<T>, Range<T>>(intersection, iterator.next()).apply((Iterator<Range<T>>)iterator);
    }

    public Range<T> symmetricDifference(Range<T> lhs, Range<T> rhs) {
        SymmetricDifference<T> symmetricDifference = new SymmetricDifference<T>(this.sequencer, this.comparator, this.emptyValue);
        return symmetricDifference.apply(lhs, rhs);
    }

    public Range<T> symmetricDifference(Range<T> first, Range<T> second, Range<T> third) {
        SymmetricDifference<T> symmetricDifference = new SymmetricDifference<T>(this.sequencer, this.comparator, this.emptyValue);
        return symmetricDifference.apply(symmetricDifference.apply(first, second), third);
    }

    public Range<T> symmetricDifference(Iterator<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot evaluate symmetric difference for a null iterator of ranges", new Object[0]);
        dbc.precondition(ranges.hasNext(), "cannot evaluate symmetric difference for an empty iterator of ranges", new Object[0]);
        SymmetricDifference<T> symmetricDifference = new SymmetricDifference<T>(this.sequencer, this.comparator, this.emptyValue);
        return new Reductor<Range<T>, Range<T>>(symmetricDifference, ranges.next()).apply(ranges);
    }

    public Range<T> symmetricDifference(Iterable<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot evaluate symmetric difference for a null iterable of ranges", new Object[0]);
        dbc.precondition(ranges.iterator().hasNext(), "cannot evaluate symmetric difference for an empty iterable of ranges", new Object[0]);
        Iterator<Range<T>> iterator = ranges.iterator();
        SymmetricDifference<T> symmetricDifference = new SymmetricDifference<T>(this.sequencer, this.comparator, this.emptyValue);
        return new Reductor<Range<T>, Range<T>>(symmetricDifference, iterator.next()).apply(iterator);
    }

    public Range<T> symmetricDifference(Range<T> ... ranges) {
        dbc.precondition(ranges != null, "cannot evaluate symmetric difference for a null array of ranges", new Object[0]);
        dbc.precondition(ranges.length != 0, "cannot evaluate symmetric difference for an empty array of ranges", new Object[0]);
        ArrayIterator<Range<T>> iterator = new ArrayIterator<Range<T>>(ranges);
        SymmetricDifference<T> symmetricDifference = new SymmetricDifference<T>(this.sequencer, this.comparator, this.emptyValue);
        return (Range)new Reductor<Range<T>, Range<T>>(symmetricDifference, iterator.next()).apply((Iterator<Range<T>>)iterator);
    }

    public Range<T> difference(Range<T> lhs, Range<T> rhs) {
        Difference<T> difference = new Difference<T>(this.sequencer, this.comparator, this.emptyValue);
        return difference.apply(lhs, rhs);
    }

    public Range<T> difference(Range<T> first, Range<T> second, Range<T> third) {
        Difference<T> difference = new Difference<T>(this.sequencer, this.comparator, this.emptyValue);
        return difference.apply(difference.apply(first, second), third);
    }

    public Range<T> difference(Iterator<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot evaluate difference for a null iterator of ranges", new Object[0]);
        dbc.precondition(ranges.hasNext(), "cannot evaluate difference for an empty iterator of ranges", new Object[0]);
        Difference<T> difference = new Difference<T>(this.sequencer, this.comparator, this.emptyValue);
        return new Reductor<Range<T>, Range<T>>(difference, ranges.next()).apply(ranges);
    }

    public Range<T> difference(Iterable<Range<T>> ranges) {
        dbc.precondition(ranges != null, "cannot evaluate difference for a null iterable of ranges", new Object[0]);
        dbc.precondition(ranges.iterator().hasNext(), "cannot evaluate difference for an empty iterable of ranges", new Object[0]);
        Iterator<Range<T>> iterator = ranges.iterator();
        Difference<T> difference = new Difference<T>(this.sequencer, this.comparator, this.emptyValue);
        return new Reductor<Range<T>, Range<T>>(difference, iterator.next()).apply(iterator);
    }

    public Range<T> difference(Range<T> ... ranges) {
        dbc.precondition(ranges != null, "cannot evaluate difference for a null array of ranges", new Object[0]);
        dbc.precondition(ranges.length != 0, "cannot evaluate difference for an empty array of ranges", new Object[0]);
        ArrayIterator<Range<T>> iterator = new ArrayIterator<Range<T>>(ranges);
        Difference<T> difference = new Difference<T>(this.sequencer, this.comparator, this.emptyValue);
        return (Range)new Reductor<Range<T>, Range<T>>(difference, iterator.next()).apply((Iterator<Range<T>>)iterator);
    }
}

