/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.emaze.dysfunctional.Consumers;
import net.emaze.dysfunctional.Filtering;
import net.emaze.dysfunctional.Reductions;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.iterations.ArrayIterator;
import net.emaze.dysfunctional.reductions.Count;
import net.emaze.dysfunctional.tuples.Pair;

public abstract class Pagination {
    public static <T> Pair<Integer, List<T>> page(long start, long howMany, Iterator<T> iterator) {
        Pair<Long, List<T>> page = LongPages.page(start, howMany, iterator);
        dbc.state(page.first() <= Integer.MAX_VALUE, "iterator size overflows an integer", new Object[0]);
        return Pair.of(page.first().intValue(), page.second());
    }

    public static <T, C extends Collection<T>> Pair<Integer, C> page(long start, long howMany, Iterator<T> iterator, C collection) {
        Pair<Long, C> page = LongPages.page(start, howMany, iterator, collection);
        dbc.state(page.first() <= Integer.MAX_VALUE, "iterator size overflows an integer", new Object[0]);
        return Pair.of(page.first().intValue(), page.second());
    }

    public static <T> Pair<Integer, List<T>> page(long start, long howMany, Iterable<T> iterable) {
        dbc.precondition(iterable != null, "cannot call page with a null iterable", new Object[0]);
        return Pagination.page(start, howMany, iterable.iterator());
    }

    public static <T, C extends Collection<T>> Pair<Integer, C> page(long start, long howMany, Iterable<T> iterable, C collection) {
        dbc.precondition(iterable != null, "cannot call page with a null iterable", new Object[0]);
        return Pagination.page(start, howMany, iterable.iterator(), collection);
    }

    public static <T> Pair<Integer, List<T>> page(long start, long howMany, T[] array) {
        return Pagination.page(start, howMany, new ArrayIterator<T>(array));
    }

    public static <T, C extends Collection<T>> Pair<Integer, C> page(long start, long howMany, T[] array, C collection) {
        return Pagination.page(start, howMany, new ArrayIterator<T>(array), collection);
    }

    public static <T> Pair<Integer, List<T>> page(long start, long howMany, Collection<T> collection) {
        return Pair.of(collection.size(), Consumers.all(Filtering.slice(start, howMany, collection)));
    }

    public static <T, C extends Collection<T>> Pair<Integer, C> page(long start, long howMany, Collection<T> in, C out) {
        return Pair.of(in.size(), Consumers.all(Filtering.slice(start, howMany, in), out));
    }

    public static class LongPages {
        public static <T> Pair<Long, List<T>> page(long start, long howMany, Iterator<T> iterator) {
            ArrayList collection = new ArrayList();
            return LongPages.page(start, howMany, iterator, collection);
        }

        public static <T, C extends Collection<T>> Pair<Long, C> page(long start, long howMany, Iterator<T> iterator, C collection) {
            C sliced = Consumers.all(Filtering.slice(start, howMany, iterator), collection);
            long fullSize = Reductions.reduce(iterator, new Count(), Long.valueOf(start + (long)sliced.size()));
            return Pair.of(fullSize, sliced);
        }

        public static <T> Pair<Long, List<T>> page(long start, long howMany, Iterable<T> iterable) {
            dbc.precondition(iterable != null, "cannot call page with a null iterable", new Object[0]);
            return LongPages.page(start, howMany, iterable.iterator());
        }

        public static <T, C extends Collection<T>> Pair<Long, C> page(long start, long howMany, Iterable<T> iterable, C collection) {
            dbc.precondition(iterable != null, "cannot call pagel with a null iterable", new Object[0]);
            return LongPages.page(start, howMany, iterable.iterator(), collection);
        }

        public static <T> Pair<Long, List<T>> page(long start, long howMany, T[] array) {
            return LongPages.page(start, howMany, new ArrayIterator<T>(array));
        }

        public static <T, C extends Collection<T>> Pair<Long, C> page(long start, long howMany, T[] array, C collection) {
            return LongPages.page(start, howMany, new ArrayIterator<T>(array), collection);
        }

        public static <T> Pair<Long, List<T>> page(long start, long howMany, Collection<T> collection) {
            dbc.precondition(collection != null, "cannot call pagel with a null collection", new Object[0]);
            return Pair.of(Long.valueOf(collection.size()), Consumers.all(Filtering.slice(start, howMany, collection)));
        }

        public static <T, C extends Collection<T>> Pair<Long, C> page(long start, long howMany, Collection<T> in, C out) {
            dbc.precondition(in != null, "cannot call pagel with a null input collection", new Object[0]);
            return Pair.of(Long.valueOf(in.size()), Consumers.all(Filtering.slice(start, howMany, in), out));
        }
    }
}

