/*
 * Decompiled with CFR 0.152.
 */
package net.emaze.dysfunctional;

import java.util.Iterator;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.emaze.dysfunctional.Consumers;
import net.emaze.dysfunctional.Iterations;
import net.emaze.dysfunctional.contracts.dbc;
import net.emaze.dysfunctional.dispatching.composing.AllMatchingBinaryPredicate;
import net.emaze.dysfunctional.dispatching.composing.AllMatchingPredicate;
import net.emaze.dysfunctional.dispatching.composing.AllMatchingTernaryPredicate;
import net.emaze.dysfunctional.dispatching.composing.FirstMatchingBinaryPredicate;
import net.emaze.dysfunctional.dispatching.composing.FirstMatchingPredicate;
import net.emaze.dysfunctional.dispatching.composing.FirstMatchingTernaryPredicate;
import net.emaze.dysfunctional.dispatching.logic.Always;
import net.emaze.dysfunctional.dispatching.logic.BinaryAlways;
import net.emaze.dysfunctional.dispatching.logic.BinaryNever;
import net.emaze.dysfunctional.dispatching.logic.Never;
import net.emaze.dysfunctional.dispatching.logic.TernaryAlways;
import net.emaze.dysfunctional.dispatching.logic.TernaryNever;
import net.emaze.dysfunctional.dispatching.logic.TriPredicate;

public abstract class Logic {
    public static <T> Predicate<T> and(Predicate<T> first, Predicate<T> second) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        return Unary.and(Iterations.iterable(first, second));
    }

    public static <T> Predicate<T> and(Predicate<T> first, Predicate<T> second, Predicate<T> third) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        dbc.precondition(third != null, "third predicate is null", new Object[0]);
        return Unary.and(Iterations.iterable(first, second, third));
    }

    public static <T> Predicate<T> and(Predicate<T> ... predicates) {
        dbc.precondition(predicates != null, "predicates is null", new Object[0]);
        return Unary.and(Iterations.iterable(predicates));
    }

    public static <T1, T2> BiPredicate<T1, T2> and(BiPredicate<T1, T2> first, BiPredicate<T1, T2> second) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        return Binary.and(Iterations.iterable(first, second));
    }

    public static <T1, T2> BiPredicate<T1, T2> and(BiPredicate<T1, T2> first, BiPredicate<T1, T2> second, BiPredicate<T1, T2> third) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        dbc.precondition(third != null, "third predicate is null", new Object[0]);
        return Binary.and(Iterations.iterable(first, second, third));
    }

    public static <T1, T2> BiPredicate<T1, T2> and(BiPredicate<T1, T2> ... predicates) {
        dbc.precondition(predicates != null, "predicates is null", new Object[0]);
        return Binary.and(Iterations.iterable(predicates));
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> and(TriPredicate<T1, T2, T3> first, TriPredicate<T1, T2, T3> second) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        return Ternary.and(Iterations.iterable(first, second));
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> and(TriPredicate<T1, T2, T3> first, TriPredicate<T1, T2, T3> second, TriPredicate<T1, T2, T3> third) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        dbc.precondition(third != null, "third predicate is null", new Object[0]);
        return Ternary.and(Iterations.iterable(first, second, third));
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> and(TriPredicate<T1, T2, T3> ... predicates) {
        dbc.precondition(predicates != null, "predicates is null", new Object[0]);
        return Ternary.and(Iterations.iterable(predicates));
    }

    public static <T> Predicate<T> or(Predicate<T> first, Predicate<T> second) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        return Unary.or(Iterations.iterable(first, second));
    }

    public static <T> Predicate<T> or(Predicate<T> first, Predicate<T> second, Predicate<T> third) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        dbc.precondition(third != null, "third predicate is null", new Object[0]);
        return Unary.or(Iterations.iterable(first, second, third));
    }

    public static <T> Predicate<T> or(Predicate<T> ... predicates) {
        dbc.precondition(predicates != null, "first predicate is null", new Object[0]);
        return Unary.or(Iterations.iterable(predicates));
    }

    public static <T1, T2> BiPredicate<T1, T2> or(BiPredicate<T1, T2> first, BiPredicate<T1, T2> second) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        return Binary.or(Iterations.iterable(first, second));
    }

    public static <T1, T2> BiPredicate<T1, T2> or(BiPredicate<T1, T2> first, BiPredicate<T1, T2> second, BiPredicate<T1, T2> third) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        dbc.precondition(third != null, "third predicate is null", new Object[0]);
        return Binary.or(Iterations.iterable(first, second, third));
    }

    public static <T1, T2> BiPredicate<T1, T2> or(BiPredicate<T1, T2> ... predicates) {
        dbc.precondition(predicates != null, "predicates is null", new Object[0]);
        return Binary.or(Iterations.iterable(predicates));
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> or(TriPredicate<T1, T2, T3> first, TriPredicate<T1, T2, T3> second) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        return Ternary.or(Iterations.iterable(first, second));
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> or(TriPredicate<T1, T2, T3> first, TriPredicate<T1, T2, T3> second, TriPredicate<T1, T2, T3> third) {
        dbc.precondition(first != null, "first predicate is null", new Object[0]);
        dbc.precondition(second != null, "second predicate is null", new Object[0]);
        dbc.precondition(third != null, "third predicate is null", new Object[0]);
        return Ternary.or(Iterations.iterable(first, second, third));
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> or(TriPredicate<T1, T2, T3> ... predicates) {
        dbc.precondition(predicates != null, "predicates is null", new Object[0]);
        return Ternary.or(Iterations.iterable(predicates));
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        dbc.precondition(predicate != null, "cannot negate a null predicate", new Object[0]);
        return predicate.negate();
    }

    public static <T1, T2> BiPredicate<T1, T2> not(BiPredicate<T1, T2> predicate) {
        dbc.precondition(predicate != null, "cannot negate a null predicate", new Object[0]);
        return predicate.negate();
    }

    public static <T1, T2, T3> TriPredicate<T1, T2, T3> not(TriPredicate<T1, T2, T3> predicate) {
        dbc.precondition(predicate != null, "cannot negate a null predicate", new Object[0]);
        return predicate.negate();
    }

    public static abstract class Ternary {
        public static <T1, T2, T3> TriPredicate<T1, T2, T3> and(Iterable<TriPredicate<T1, T2, T3>> predicates) {
            return new AllMatchingTernaryPredicate(predicates);
        }

        public static <T1, T2, T3> TriPredicate<T1, T2, T3> and(Iterator<TriPredicate<T1, T2, T3>> predicates) {
            return new AllMatchingTernaryPredicate(Consumers.all(predicates));
        }

        public static <T1, T2, T3> TriPredicate<T1, T2, T3> or(Iterable<TriPredicate<T1, T2, T3>> predicates) {
            return new FirstMatchingTernaryPredicate(predicates);
        }

        public static <T1, T2, T3> TriPredicate<T1, T2, T3> or(Iterator<TriPredicate<T1, T2, T3>> predicates) {
            return new FirstMatchingTernaryPredicate(Consumers.all(predicates));
        }

        public static <T1, T2, T3> TriPredicate<T1, T2, T3> always() {
            return new TernaryAlways();
        }

        public static <T1, T2, T3> TriPredicate<T1, T2, T3> never() {
            return new TernaryNever();
        }
    }

    public static abstract class Binary {
        public static <T1, T2> BiPredicate<T1, T2> and(Iterable<BiPredicate<T1, T2>> predicates) {
            return new AllMatchingBinaryPredicate(predicates);
        }

        public static <T1, T2> BiPredicate<T1, T2> and(Iterator<BiPredicate<T1, T2>> predicates) {
            return new AllMatchingBinaryPredicate(Consumers.all(predicates));
        }

        public static <T1, T2> BiPredicate<T1, T2> or(Iterable<BiPredicate<T1, T2>> predicates) {
            return new FirstMatchingBinaryPredicate(predicates);
        }

        public static <T1, T2> BiPredicate<T1, T2> or(Iterator<BiPredicate<T1, T2>> predicates) {
            return new FirstMatchingBinaryPredicate(Consumers.all(predicates));
        }

        public static <T1, T2> BiPredicate<T1, T2> always() {
            return new BinaryAlways();
        }

        public static <T1, T2> BiPredicate<T1, T2> never() {
            return new BinaryNever();
        }
    }

    public static abstract class Unary {
        public static <T> Predicate<T> and(Iterable<Predicate<T>> predicates) {
            return new AllMatchingPredicate(predicates);
        }

        public static <T> Predicate<T> and(Iterator<Predicate<T>> predicates) {
            return new AllMatchingPredicate(Consumers.all(predicates));
        }

        public static <T> Predicate<T> or(Iterable<Predicate<T>> predicates) {
            return new FirstMatchingPredicate(predicates);
        }

        public static <T> Predicate<T> or(Iterator<Predicate<T>> predicates) {
            return new FirstMatchingPredicate(Consumers.all(predicates));
        }

        public static <T> Predicate<T> always() {
            return new Always();
        }

        public static <T> Predicate<T> never() {
            return new Never();
        }
    }
}

